<?php

//////////////////////////////////////////////////////////////
//===========================================================
// manage_sets_theme.php
//===========================================================
// SOFTACULOUS 
// Version : 1.1
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       10th Jan 2009
// Time:       21:00 hrs
// Site:       http://www.softaculous.com/ (SOFTACULOUS)
// ----------------------------------------------------------
// Please Read the Terms of use at http://www.softaculous.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Inc.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('SOFTACULOUS')){

	die('Hacking Attempt');

}

function manage_sets_theme(){

global $globals, $l, $theme, $langs, $error, $sets, $sites, $user, $themes_count, $plugins_count, $selected_set, $done, $admin_sets, $all_sets;

//Code is placed here to prevent the theme part below this from displaying.
//Search for plugins/themes
if(optGET('search_key')){
	$search_key = inputsec(trim($_GET['search_key']));
	$is_plugin = optGET('plugins');
	search_wp_plugins_themes($search_key, $is_plugin);
	return false;
}

if(optGET('ajcall')){
	if(!empty($error)){
		echo '0'.current($error);
		return false;
	}
}

softheader(__('$0 - WordPress Plugin / Theme Sets', array($globals['sn'])));

echo '
<script language="javascript" type="text/javascript"><!-- // --><![CDATA[

var sets_list = '.json_encode($all_sets, JSON_FORCE_OBJECT).';

$( document ).ready(function() {
	
	multiple_checks();
	
	$("#create_sets").click(function(){
		$("#add_sets_div").slideToggle();
	});
	
	$("#add_sets").click(function(){
		
		var set_nam = $("#set_input").val();
		var validate = /[a-zA-Z0-9_\- ]+/;
		
		for (var i=0; i < set_nam.length; i++) {
			
			if(!(validate.test(set_nam[i]))){
				alert("'.__js('Only Alphanumeric characters, hyphen and underscore are allowed').'");
				return false;
			}
		}
		
		$("#add_sets_div").slideToggle();
	});
	
	//Remove sets
	$("#remove_sets").click(function(){
		
		var sets =  document.getElementsByName("sets[]");
		
		sets_data = new Array();
		var c = 0;
		for(i = 0; i < sets.length; i++){
			if(sets[i].checked == true){
				sets_data[c] = sets[i].id;
				c++;
			}
		}
		
		//No sets selected to remove, abort it
		if(sets_data.length == 0){
			alert("'.__js('Please select set(s) to remove').'");
			return false;
		}
		
		var csrf_token = $("#csrf_token").val(); 
		
		$.ajax({
			url: window.location+"&ajcall=1&jsnohf=1&remove_sets=1",
			type: "POST",
			data: {csrf_token:csrf_token,sets:sets_data},
			success: function(data){
				var result = data.substring(0,1);					
				var msg = data.substring(1);
				
				if(result == "0"){					
					$("#plugin_removed_failure").html(msg).css("text-align", "center");
					$("#plugin_removed_failure").show();
				}else{
					if(sets_data.length > 0){
						alert("'.__js('Set(s) removed successfully').'");
					}
					
					//To prevent from asking resend popup while reloading page
					window.location.href = window.location.href;
					
				}
			}
		});		
		
	});
	
	//Set default value
	$(".default_value").on("click", function(event){
	
		var set_name = $(this).attr("id");
		set_name = set_name.replace("default_value_", "");
		var csrf_token = $("#csrf_token").val();
		
		if(this.checked == true){
			checked = 1;
		}else{
			checked = 0;
		}
		
		$.ajax({
			url: window.location+"&api=json&set_name="+encodeURIComponent(set_name)+"&default_value="+encodeURIComponent(checked),
			type: "POST",
			data: "csrf_token="+csrf_token,
			success: function(data){
				if(!data){
					alert("'.__js('No response received').'");
					return false;
				}
				
				var resp = JSON.parse(data);
				if(!resp){
					alert("'.__js('Invalid response received').'");
					return false;
				}
				
				if(!resp.done){
					
					if(resp.error){
						var error_disp = "'.__js('The following errors were found').':\n";
						for(x in resp.error){
							error_disp = error_disp+resp.error[x]+"\n";
						}
						alert(error_disp);
						return false;
					}
					
					alert("'.__js('Failed to save preference').'");
					return true;
				}
				
				alert(resp.done);
			}
		});		
		
		
	});
	
	function multiple_checks(){
		$("#check_allsets").on("click", function(event){
			if(this.checked == true){
				$(".check_allsets").prop("checked", true);
			}else{
				$(".check_allsets").prop("checked", false);
			}
		});
	}
});

function remove_plugin_submit(){
	var plugin_or_theme = $("#plugin_or_theme").val();
	
	if(plugin_or_theme == "plugins"){
		plugin_or_theme = "plugins";
		$("#plugin_removed_success").text("'.__js('Plugin(s) removed successfully').'").css("text-align", "center");
	}else{
		plugin_or_theme = "themes";
		$("#plugin_removed_success").text("'.__js('Theme(s) removed successfully').'").css("text-align", "center");
	}
	
	var remove_plugins_themes =  document.getElementsByName("remove_plugins_themes[]");
	
	plugins_themes_to_remove = new Array();
	var c = 0;
	for(i = 0; i < remove_plugins_themes.length; i++){
		if(remove_plugins_themes[i].checked == true){
			plugins_themes_to_remove[c] = remove_plugins_themes[i].value;
			c++;
		}
	}
	
	var set = $("#plugin_theme_set").val();
	var csrf_token = $("#csrf_token").val();
	
	$_("rem_plth_"+set).innerHTML = "<a><img src=\''.$theme['images'].'load.gif\' alt=\''.__js('Removing').'\' width=\'25\' ></a>";
	
	$.ajax({
		url: window.location+"&ajcall=1&jsnohf=1&plugins_themes_to_remove="+encodeURIComponent(plugins_themes_to_remove)+"&set_name="+encodeURIComponent(set)+"&"+plugin_or_theme+"=1",
		type: "POST",
		data: "csrf_token="+csrf_token,
		success: function(data){
			//alert(data);
			
			var result = data.substring(0,1);					
			var msg = data.substring(1);
			
			if(result == "0"){
				$("#plugin_removed_failure").html(msg).css("text-align", "center");
				$("#plugin_removed_failure").show();
				$_("rem_plth_"+set).innerHTML = "";				
			}else{
				if(plugins_themes_to_remove.length > 0){
					$("#plugin_removed_success").fadeTo(3000, 500).slideUp(1000, function(){
						$("#plugin_removed_success").slideUp(1000);
					});
				}
				
				var plugins_count = parseInt($(data).find("#plugins_count").val());	
				var themes_count = parseInt($(data).find("#themes_count").val());
				
				if(plugin_or_theme == "plugins"){	
					if(plugins_count === 0){
						$("#"+set+"_plugin_count").html("");
					}else{
						$("#"+set+"_plugin_count").html(plugins_count+"'.__js(' Total').'");
					}
				}else{
					if(themes_count === 0){
						$("#"+set+"_theme_count").html("");
					}else{
						$("#"+set+"_theme_count").html(themes_count+"'.__js(' Total').'");
					}
				}			
				$_("rem_plth_"+set).innerHTML = "";
			}
		}
	});
}

//Creates the list of plugins/themes to remove via modal(popup)
function remove_wp_plugins_themes(set, to_remove){
	
	var set_data, plugins_themes_list;
	
	$("#remove_plugins_themes").empty();
	
	var csrf_token = $("#csrf_token").val();
	
	//Get plugins_themes count
	$.ajax({
		type: "POST",
		data: "csrf_token="+csrf_token,
		url: window.location+"&jsnohf=1&set_stats="+encodeURIComponent(set)+"&get_plugins_themes_count=1",
		timeout:0,
		// Checking for success
		success: function(data){	
			var selected_set = $(data).find("#selected_set").text();
			var selected_set_data = JSON.parse(selected_set);
			
			if(to_remove == "plugins"){
				$(".modal-title").text("'.__js('Select Plugins to remove').'");
				set_data = selected_set_data.plugins;
			}else{
				$(".modal-title").text("'.__js('Select Themes to remove').'");
				set_data = selected_set_data.themes;
			}
			
			$("#plugin_or_theme").val(to_remove);
			$("#plugin_theme_set").val(set);
			
			//var tmp = plugins_themes.split(",");
			
			if(set_data === undefined || set_data.length <= 0){
				if(to_remove == "plugins"){
					plugins_themes_list = "'.__js('No plugins to remove').'"; 
				}else{
					plugins_themes_list = "'.__js('No themes to remove').'"; 
				}
				
				$("#remove_plugins_themes").append("<tr><td><div class=\'alert alert-warning\'>"+plugins_themes_list+"</div></td></tr><br />");
				
				return false;
			}
			
			for(var slug in set_data){
				//alert(slug);
				//alert(set_data[slug]);
				
				var plugin_list = "";
				
				plugins_themes_list = "<input id="+set+" type=\"checkbox\" name=\"remove_plugins_themes[]\"  value=\'"+slug+"\'></td><td>"+set_data[slug];
			
				$("#remove_plugins_themes").append("<tr><td width=\"25px\">"+plugins_themes_list+"</td></tr><br />");
			}
		}
	});
}

function add_plugins_themes(set_name, vall){
	
	//Clean previous search value or results
	$("#search_input_wp").val("");
	$("#plugin_theme_results").empty();
	
	$("#set_post").val("");
	//alert(set_name);
	//alert(vall);
	$("#set_post").val(set_name); // To determine in which set the plugin or thmes to be added	
	$("#plugin_or_theme").val(vall); // To determine if the search is for theme or plugin	
	
	$("#add_success").text("");
	$("#add_success").hide();
	$("#add_failed").text("");
	$("#add_failed").hide();
	
	if(vall == "Add Plugins"){
		$(".modal-title").text("'.__js('Select Plugins to add').'");
	}else{
		$(".modal-title").text("'.__js('Select Themes to add').'");
	}
	
}

//Filters the plugin search result
function filter_plugins(){
		
	var val = $("#search_input_wp").val();
	var plugin_or_theme = $("#plugin_or_theme").val();
	
	if(plugin_or_theme == "'.__js('Add Plugins').'"){
		plugin_or_theme = "plugins";
	}else{
		plugin_or_theme = "themes";
	}
	
	$.ajax({
		url: window.location+"&ajcall=1&jsnohf=1&search_key="+encodeURIComponent(val)+"&"+plugin_or_theme+"=1",
		type: "GET",
		success: function(data){//alert(data);			
			var input, filter, table, tr, td, i;
			input = document.getElementById("search_input_wp");
			filter = input.value.toUpperCase();
			
			$("#plugin_theme_results").html(data);
			
			table = document.getElementById("plugin_theme_results");
			
			tr = table.getElementsByTagName("tr");
			
			for (i = 0; i < tr.length; i++) {
				td = tr[i].getElementsByTagName("td")[1];     
			}			
		}
	});	
}

function submit_addition(){
	$_("add_plth").innerHTML = "<a><img src=\''.$theme['images'].'load.gif\' alt=\''.__js('Adding').'\' width=\'25\' ></a>";
	
	var is_plugin_or_theme = $("#plugin_or_theme").val();

	if(is_plugin_or_theme == "'.__js('Add Plugins').'"){
		is_plugin_or_theme = "plugins";
	}else{
		is_plugin_or_theme = "themes";
	}
	
	var plugins_or_themes = document.getElementsByName("plugins_or_themes[]");
	var sets_name =  $("#set_post").val();
	
	//var add_plugins_themes_data = new Object();
	//var add_plugins_themes_data = new Array();
	var slugs = new Array();
	var names = new Array();
	
	var c = 0;
	for(i = 0; i < plugins_or_themes.length; i++){
		
		if(plugins_or_themes[i].checked == true){
			//var plth_id = plugins_or_themes[i].value;
			//alert("Slug: "+plug_theme_name);
			//add_plugins_themes_data[plugins_or_themes[i].value] = document.getElementById(plugins_or_themes[i].value).innerHTML;
			
			//add_plugins_themes_data.plth_id = document.getElementById(plugins_or_themes[i].value).innerHTML;
			
			//alert("Name: "+document.getElementById(plugins_or_themes[i].value).innerHTML);
			
			slugs[c] = plugins_or_themes[i].value;
			names[c] = document.getElementById(plugins_or_themes[i].value).value;
			c++;
		}
	}
	//alert(add_plugins_themes_data);
	
	
	//var jsonString = JSON.stringify(add_plugins_themes_data);alert("JSONstring: "+jsonString);
	
	if(slugs.length == 0){
		if(is_plugin_or_theme == "plugins"){
			$("#add_failed").text("'.__js('Please select some plugins').'").css("text-align", "center");
		}else{
			$("#add_failed").text("'.__js('Please select some themes').'").css("text-align", "center");
		}
		$("#add_failed").show();
		$("#add_success").hide();
		$_("add_plth").innerHTML = "";
		return false;
		
	}else{
		
		var csrf_token = $("#csrf_token").val(); 
		
		$.ajax({
			url: window.location+"&ajcall=1&jsnohf=1&sets_name="+encodeURIComponent(sets_name)+"&"+is_plugin_or_theme+"=1&add_plugins_themes_data=1",
			type: "POST",
			data: {add_plugins_themes_data_slugs : slugs, add_plugins_themes_data_names : names, csrf_token : csrf_token},
			//data: {add_plugins_themes_data_slugs : JSON.stringify(slugs), add_plugins_themes_data_names : JSON.stringify(names)},
			success: function(data){
				//alert(data);
				
				var result = data.substring(0,1);					
				var msg = data.substring(1);
				
				if(result == "0"){					
					$("#add_failed").show();
					$("#add_failed").html(msg);
					$_("add_plth").innerHTML = "";
					
				}else{					
					if(is_plugin_or_theme == "plugins"){
						$("#add_success").text("'.__js('The plugin(s) added successfully').'").css("text-align", "center");	
					}else{
						$("#add_success").text("'.__js('The theme(s) added successfully').'").css("text-align", "center");
					}
					
					$("#add_failed").hide();
					$("#add_success").show();
					$("#plugin_theme_results").empty();
					$_("add_plth").innerHTML = "";
					
					var plugins_count = $(data).find("#plugins_count").val();	
					var themes_count = $(data).find("#themes_count").val();
					
					if(is_plugin_or_theme == "plugins"){
						$("#"+sets_name+"_plugin_count").html(plugins_count+"'.__js(' Total').'");
					}else{
						$("#"+sets_name+"_theme_count").html(themes_count+"'.__js(' Total').'");
					}
				}
			},
			error: function(data) {
				$_("add_plth").innerHTML = "";
			}
		});
	}
	
	return true;
}

var search_timer;

$(document).on("keyup", "#search_input_wp",  function(e) {
	
	var search_string = $(this).val();
	clearTimeout(search_timer);

	if (search_string == "") {
		$("#plugin_theme_results").hide();
	}else{
		$("#plugin_theme_results").show();
		search_timer = setTimeout("filter_plugins();", 300);
	};
});

//on keydown, clear the countdown 
$(document).on("keydown", "#search_input_wp", function () {
  clearTimeout(search_timer);
});

function list_set_items(setname){
	
	var set_plugins, set_themes, plugins_data, themes_data;
	
	$(".modal-title").text(setname.replace("_admin", ""));
	
	$("#list_plugins_themes").empty();
	
	var csrf_token = $("#csrf_token").val();
	
	//Get plugins_themes count
	$.ajax({
		type: "POST",
		data: "csrf_token="+csrf_token,
		url: window.location+"&jsnohf=1&set_stats="+encodeURIComponent(setname)+"&get_plugins_themes_count=1",
		timeout:0,
		// Checking for success
		success: function(data){
			var selected_set = $(data).find("#selected_set").text();
			var selected_set_data = JSON.parse(selected_set);
			
			var set_plugins = new Object();
			var set_themes = new Object();
			
			if(selected_set_data.plugins){
				set_plugins = selected_set_data.plugins;
			}
			
			if(selected_set_data.themes){
				set_themes = selected_set_data.themes;
			}
			
			if(selected_set_data.custom_plugins){
				for(var x in selected_set_data.custom_plugins){
					set_plugins[selected_set_data.custom_plugins[x].slug] = selected_set_data.custom_plugins[x].name;
				}
			}
			
			if(selected_set_data.custom_themes){
				for(var x in selected_set_data.custom_themes){
					set_themes[selected_set_data.custom_themes[x].slug] = selected_set_data.custom_themes[x].name;
				}
			}
			
			if((set_plugins === undefined || (set_plugins.length <= 0 && Object.keys(set_plugins) <= 0)) && (set_themes === undefined || (set_themes.length <= 0 && Object.keys(set_themes) <= 0))){
				$("#list_plugins_themes").append("<div class=\'alert alert-warning\'>'.__js('There are currently no items in the set!!').'</div>");
			}
			
			//Plugins
			if(set_plugins !== undefined){
				plugins_data = "<h4>'.__js('Plugins').'</h4><ul class=\"softlist\">";
				for(var pl in set_plugins){
					plugins_data += "<li>"+set_plugins[pl]+"</li>";
				}
				$("#list_plugins_themes").append("</ul>" + plugins_data);
			}
			
			//Themes
			if(set_themes !== undefined){
				themes_data = "<br /><h4>'.__js('Themes').'</h4><ul class=\"softlist\">";
				for(var th in set_themes){
					themes_data += "<li>"+set_themes[th]+"</li>";
				}
				$("#list_plugins_themes").append("</ul>" + themes_data);
			}
		}
	});
}

function show_softinstall_set_modal(setname){
	
	$("#installations_list").hide();
	$("#no_plugins_themes").hide();
	$("#install_success").hide();	
	$("#install_failed").hide();
	
	$(".has_set").each(function(){
		$(this).show();
	});
	
	var csrf_token = $("#csrf_token").val();
	
	//Get plugins_themes count
	$.ajax({
		type: "POST",
		data: "csrf_token="+csrf_token,
		url: window.location+"&ajcall=1&jsnohf=1&set_stats="+encodeURIComponent(setname)+"&get_plugins_themes_count=1",
		timeout:0,
		// Checking for success
		success: function(data){
			var result = data.substring(0,1);					
			var msg = data.substring(1);
				
			if(result == "0"){
				alert(msg);
			}else{
				var plugins_count = $(data).find("#plugins_count").val();	
				var themes_count = $(data).find("#themes_count").val();
				
				if(plugins_count == 0 && themes_count == 0){
					$("#no_plugins_themes").text("'.__js("Set doesn't contain any plugins or themes").'");
					$("#no_plugins_themes").show();
					$("#softsubmit_install_set").hide(); //hide button
				}else{
					var sel_set_slug = slugify(setname);
					$(".has_set").each(function(){
						($(this).attr("name").search(sel_set_slug) != -1) ? "" : $(this).hide();
					});
					$("#installations_list").show();
					$("#softsubmit_install_set").show(); //show button
				}
			}
		}
	
	});
	
	$(".modal-title").text("'.__js('Install Set').'");
	$("#softinstall_set_name").val(setname);
	$(".check_websites").prop("checked", false);
}

function softsubmit_install_set(){

	$_("install_div").innerHTML = "<a><img src=\''.$theme['images'].'load.gif\' alt=\''.__js('Installing').'\' width=\'25\' ></a>";
	
	var setname = $("#softinstall_set_name").val();
	
	var softwebsites = document.getElementsByName("webids[]");
	
	var ins_path = new Array();
	var c = 0;
	for(var i = 0; i < softwebsites.length; i++){
		if(softwebsites[i].checked == true){
			ins_path[c] = softwebsites[i].value;
			c++;
		}
	}
	
	//When there is no site selected
	if ((ins_path === undefined || ins_path.length <= 0)) {
		$("#install_failed").show();
		$("#install_failed").html("'.__js('Please select some sites').'");
		$_("install_div").innerHTML = "";
		return true;
	}
	
	ins_path.toString();
	var csrf_token = $("#csrf_token").val();
	
	$.ajax({
		type: "POST",
		data: "csrf_token="+csrf_token,
		url: window.location+"&ajcall=1&jsnohf=1&softinstall_set="+encodeURIComponent(setname)+"&softwebsites="+encodeURIComponent(ins_path),
		timeout:0,
		// Checking for success
		success: function(data){
			var result = data.substring(0,1);					
			var msg = data.substring(1);
				
			if(result == "0"){
				$("#install_failed").html(msg);
				$("#install_failed").show();
				$("#install_success").hide();
			}else{
				$("#install_failed").hide();
				$("#install_success").show();
				$.each(ins_path, function(index){
					$("#has_set_"+ins_path[index]).attr("name", $("#has_set_"+ins_path[index]).attr("name") + slugify(setname) +":");
					$("#has_set_"+ins_path[index]).show();
				});
			}		
			
			$(".check_websites").prop("checked", false);
			$_("install_div").innerHTML = "";
		},
		error: function(data) {
			$("#install_failed").show();
			$("#install_success").hide();
			alert("'.__js('An error occurred while installing set. Please try again later!').'");
			$(".check_websites").prop("checked", false);
			$_("install_div").innerHTML = "";
		}
	});
}
// ]]></script>

<style>
.softlist{
	padding-left: 25px;
}
</style>
';

echo '<div class="bg" style="min-height:400px;"><br />
		<center class="sai_main_head" style="width:100%;" align="center">
			<i class="fas fa-chart-pie fa-2x" style="color:#00A0D2; vertical-align: middle;"></i> &nbsp;'.__('Softaculous - WordPress Plugin / Theme Sets').'
		</center><hr>';

error_handle($error);
		
// Call a HOOK to check if it is allowed to perform this function
apply_filters('can_perform_action_theme', 'manage_sets');

echo'
<input id="plugins_count" type="hidden" value="'.$plugins_count.'">
<input id="themes_count" type="hidden" value="'.$themes_count.'">
<div id="selected_set" style="display:none;">'.$selected_set.'</div>

<input name="create_sets" class="sai-button" id="create_sets" value="'.__('Create Set').'" type="button">&nbsp;&nbsp;
<input name="remove_sets" class="sai-button" id="remove_sets" value="'.__('Remove Set(s)').'" type="button">
<a role="button" href="'.$globals['ind'].'act=wordpress" style="float:right;"><span class="btn btn-outline-primary">'.__('Return to WordPress Management').'</span></a>
<br/><br/>
	<form accept-charset="'.$globals['charset'].'" name="manage_plugin_theme" method="post" action="">
		<div class="row mb-4" id="add_sets_div" style="display:none;">
			<div class="col-12">
				<input type="text" name="set_input" class="form-control w-50 d-inline-block mb-2 mb-md-0" id="set_input" size="30" placeholder="'.__('Name of the set').'"/>
				<input name="add_sets" class="sai-button d-inline-block" id="add_sets" value="'.__('Create').'" type="submit">
			</div>
		</div>
		'.csrf_display().'
	</form>
	
	<div id="plugin_removed_success" class="alert alert-success" style="display:none;"><center></center></div>
	<div id="plugin_removed_failure" class="alert alert-danger" style="display:none;"><center></center></div>
	
	<table width="80%" id="manage_plugin_theme" class="table table-hover text-center" style="margin:0px auto;">
	<thead  class="sai_head2">
		<tr>
			<th><input type="checkbox" id="check_allsets"></th>
			<th>'.__('Set Name').'</th>
			<th></th>
			<th>'.__('Plugins').'</th>
			<th></th>
			<th>'.__('Themes').'</th>
			<th></th>
			<th></th>
			<th></th>
			<th style="cursor:pointer">
				<span class="someclass" title="'.__('This will be the default state of the checkbox displayed to the enduser on the install form').'" style="cursor:pointer;">
					<font class="bboxtxt">'.__('Pre-selected').'</font>
				</span>
			</th>
		</tr>
	</thead>';
	
	//r_print($sets);
	foreach($sets as $sk => $sv){
		
		//echo '<li><a href="#">'.$av['name'].'</a></li>';
		echo '
		<tr>
			<td style="vertical-align:middle;"><input id="'.$sk.'" type="checkbox" name="sets[]" class="check_allsets"></td>
			
			<td class="class_valign">'.$sk.'</td>
			
			<td class="class_valign"><span id="'.$sk.'_plugin_count">'.(!empty($sv['plugins']) ? count($sv['plugins']) : '0').__(' Total').'</span></td>
			
			<td id="'.$sk.'"><input name="'.$sk.'" class="sai-button p-2" id=""'.$sk.'"" value="'.__('Add Plugins').'" type="button" style="padding: 2px 6px;" data-toggle="modal" data-target="#search_modal" onclick="add_plugins_themes(this.name, this.value)"></td>
			
			<td class="class_valign"><span id="'.$sk.'_theme_count">'.(!empty($sv['themes']) ? count($sv['themes']) : '0').__(' Total').'</span></td>
			
			<td id="'.$sk.'"><input name="'.$sk.'" class="sai-button p-2" id="add_themes" value="'.__('Add Themes').'" type="button" style="padding: 2px 6px;" data-toggle="modal" data-target="#search_modal" onclick="add_plugins_themes(this.name, this.value)"></td>

			<td class="class_valign"><span class="someclass" title="'.__('List Items in Set').'" style="cursor:pointer;" data-toggle="modal" data-target="#list_set_items_modal" onclick="list_set_items(\''.$sk.'\')"><i class="fas fa-2x fa-list" style="color:#676a6c;margin:3px;"></i></span></td>
			
			<td id="'.$sk.'">
				<div class="dropdown">
					<button class="sai-button p-2 dropdown-toggle" type="button" data-toggle="dropdown" style="padding: 2px 6px;">'.__('Action').'
					<span class="caret"></span></button>&nbsp;<span id="rem_plth_'.$sk.'"></span>
					<ul class="dropdown-menu p-2">
					<li id="'.implode(",", (array) $sets[$sk]['plugins']).'" class="p-1" data-toggle="modal" data-target="#remove_plugin_theme_modal" onclick="remove_wp_plugins_themes(\''.$sk.'\', \'plugins\')"><a style="text-decoration:none; cursor:pointer;">'.__('Remove Plugin(s)').'</a></li>
					<li id="'.implode(",", (array) $sets[$sk]['themes']).'" class="p-1" data-toggle="modal" data-target="#remove_plugin_theme_modal" onclick="remove_wp_plugins_themes(\''.$sk.'\', \'themes\')"><a style="text-decoration:none; cursor:pointer;">'.__('Remove Theme(s)').'</a></li>
					</ul>
				</div>
			</td>
			<td><input class="sai-button p-2" id="softinstall_set_button" value="'.__('Install Set').'" type="button" style="padding: 2px 6px;" data-toggle="modal" data-target="#softinstall_set_modal" onclick="show_softinstall_set_modal(\''.$sk.'\')"></td>
			<td style="vertical-align:middle;">'.
			(!empty($sv['themes']) || !empty($sv['plugins']) ? '<input id="default_value_'.$sk.'" type="checkbox" name="default_value" class="default_value" '.POSTchecked("default_value", $sets[$sk]['default_value']).'>' : "")
			.'</td>
		</tr>';
	}

	echo '</table>';
	
	// Is there any admin set ? 
	if(!empty($admin_sets)){
		
		echo '<br /><br />
		<span class="sai_main_head">
		<center class="sai_main_head" style="width:100%;" align="center">'.__('Predefined Sets').'
		</center><hr></span>
		<table width="80%" id="manage_plugin_theme" class="table table-hover text-center" style="margin:0px auto;">

		<thead  class="sai_head2">
			<tr>
				<th>'.__('Set Name').'</th>
				<th>'.__('Plugins').'</th>
				<th>'.__('Themes').'</th>
				<th>'.__('List items').'</th>
				<th>'.__('Install Set').'</th>
			</tr>
		</thead>';
		
		foreach($admin_sets as $sk => $sv){
			
			load_wp_sets_count($sv, $plugins_count, $themes_count);
			
			if(!empty($sv['enduser_set'])){
				continue;
			}
		
			echo '<tr>				
				<td class="class_valign">'.preg_replace('/_admin$/', '', $sk).'</td>
				
				<td class="class_valign"><span id="'.$sk.'_plugin_count">'.$plugins_count.__(' Total').'</span></td>
				
				<td class="class_valign"><span id="'.$sk.'_theme_count">'.$themes_count.__(' Total').'</span></td>

				<td class="class_valign"><span class="someclass" title="'.__('List Items in Set').'" style="cursor:pointer;" data-toggle="modal" data-target="#list_set_items_modal" onclick="list_set_items(\''.$sk.'\')"><i class="fas fa-2x fa-list" style="color:#676a6c;margin:3px;"></i></span></td>
				
				<td><input class="sai-button p-2" id="softinstall_set_button" value="'.__('Install Set').'" type="button" style="padding: 2px 6px;" data-toggle="modal" data-target="#softinstall_set_modal" onclick="show_softinstall_set_modal(\''.$sk.'\')"></td>
			</tr>';
		}
	}
	
	echo '</table>
	
	<!-- remove plugins Modal -->
	<div class="modal fade" id="remove_plugin_theme_modal" role="dialog">
		<div class="modal-dialog">
		  <div class="modal-content">
			<div class="modal-header">
			  <h5 class="modal-title"></h5>
			  <button type="button" class="close d-inline-block" data-dismiss="modal">&times;</button>
			</div>
			<div class="modal-body">
				<input type="hidden" name="plugin_or_theme" id="plugin_or_theme" value="">
				<input type="hidden" name="plugin_theme_set" id="plugin_theme_set" value="">
				<table id="remove_plugins_themes" class="table table-hover">		
				</table>
			</div>
			<div class="modal-footer">
				'.csrf_display().'
			  <button type="button" class="btn btn-default sai-button" data-dismiss="modal" id="remove_plugin_submit" onclick="remove_plugin_submit()">'.__('Remove').'</button>
			</div>
		  </div>
		</div>
	</div>

	<!-- List Set Items Modal -->
	<div class="modal fade" id="list_set_items_modal" role="dialog">
		<div class="modal-dialog">
		  <div class="modal-content">
			<div class="modal-header">
			  <h5 class="modal-title"></h5>
			  <button type="button" class="close d-inline-block" data-dismiss="modal">&times;</button>
			</div>
			<div class="modal-body" id="list_plugins_themes">
			</div>
			<div class="modal-footer">
			  <button type="button" class="btn btn-default sai-button" data-dismiss="modal">'.__('OK').'</button>
			</div>
		  </div>
		</div>
	</div>	
	
	<!--search plugins Modal -->
	<div class="modal fade" id="search_modal" role="dialog">
		<div class="modal-dialog">
		  <div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title"></h5>
				<button type="button" class="close d-inline-block" data-dismiss="modal">&times;</button>
			</div>
			<div class="modal-body">
				<div id="add_success" class="alert alert-success" style="display:none;"></div>
				<div id="add_failed" class="alert alert-danger" style="display:none;"></div>
				<input type="text" name="search_input_wp" class="form-control" id="search_input_wp" size="30" placeholder="'.__('Search from wordpress.org').'"/><br />
				<input type="hidden" name="set_post" id="set_post" value=""><br />
				<input type="hidden" name="plugin_or_theme" id="plugin_or_theme" value=""><br />
				<div id="plugin_theme_results"></div>
			</div>
			<div class="modal-footer">
				<div id="add_plth" class="wpc_inline"></div>
					'.csrf_display().'
				<button type="button" class="btn btn-default sai-button" id="submit_plugins_themes" name="submit_plugins_themes" onclick="submit_addition();">Add</button>
			</div>
		  </div>
		</div>
	</div>
	
	<!--Install Set Modal for Softaculous-->
	<div class="modal fade" id="softinstall_set_modal" role="dialog">
		<div class="modal-dialog">
		  <div class="modal-content">
			<div class="modal-header">
			  <h5 class="modal-title"></h5>
			  <button type="button" class="close d-inline-block" data-dismiss="modal">&times;</button>
			</div>
			<div class="modal-body">
				<div id="install_success" class="alert alert-success" style="display:none;">'.__('Set installed successfully').'</div>
				<div id="install_failed" class="alert alert-danger" style="display:none;">'.__('An error occurred while installing set. Please try again later!').'</div>
				<div id="no_plugins_themes" class="alert alert-warning" style="display:none;"></div>
				<input type="hidden" name="softinstall_set_name" id="softinstall_set_name" value="">
				<div id="installations_list" style="display:none;">
					<div class="sai_sub_head">Select the Websites you want to install the Set on: </div><br />
					<table  border="0" cellpadding="5" cellspacing="0" width="90%" class="table table-hover">';
					
					foreach($user['ins'] as $insid => $soft){
						if(is_wordpress($soft['sid'])){ // Only Wordpress Installs
						echo '
						<tr>
							<td><input type="checkbox" class="check_websites" name="webids[]" id="'.$insid.'" value="'.$insid.'"></td>
							<td>
								<span title="'.__('Selected Set is already installed on this website').'" id="has_set_'.$insid.'" class="has_set" name="'.( !empty($soft['sets']) ? ":".implode(":",$soft['sets']).":": ":" ).'">
								<i class="fas fa-check fa-1x" style="color: #008040;"></i>
								</span>
							</td>
							<td><label class="sai_head label" for="'.$insid.'">'.$soft["softurl"].'</label></td>
						</tr>';
						}
					}
					echo '
					</table>
				</div>	
			</div>
			
			<div class="modal-footer">
				<div id="install_div"></div>
				'.csrf_display().'
				<button type="button" class="btn btn-default sai-button" id="softsubmit_install_set" name="softsubmit_install_set" onclick="softsubmit_install_set();">Install</button>
			</div>
		  </div>
		</div>
	</div>
</div>';

softfooter();

}

?>