<?php

//////////////////////////////////////////////////////////////
//===========================================================
// settings_theme.php
//===========================================================
// SOFTACULOUS 
// Version : 1.1
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       10th Jan 2009
// Time:       21:00 hrs
// Site:       http://www.softaculous.com/ (SOFTACULOUS)
// ----------------------------------------------------------
// Please Read the Terms of use at http://www.softaculous.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Inc.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('SOFTACULOUS')){

	die('Hacking Attempt');

}

function settings_theme(){

global $theme, $globals, $user, $l, $langs, $skins, $error, $saved, $softpanel, $protocols, $timezone_list;

//Is suPHP installed ?
$apache_modules = (function_exists('apache_get_modules') ? apache_get_modules() : '');
if(is_array($apache_modules)){
	foreach($apache_modules as $av){
		if(strtolower($av) == 'mod_suphp'){
			$suphp = true;
		}
	}
}

softheader(__('$0 - User Settings', array(APP)));

echo '<div class="container-fluid">
	<div class="container my-4">
		<div class="sai-page-title text-center">
			<h2>'.__('User Settings').'</h2>
		</div>
	</div>		
</div>';

echo '<link rel="stylesheet" type="text/css" href="'.$theme['url'].'/spectrum.css?'.$globals['version'].'" />
<script src="'.$theme['url'].'/js/spectrum.js" type="text/javascript"></script>
<script language="javascript" type="text/javascript"><!-- // --><![CDATA[

function show_ud(id){
	var val = id.value;
	if(val == "user_defined"){
		$("#admin_prefix_ud").css("display", "");
	}else{
		$("#admin_prefix_ud").css("display", "none");
	}
}

function showtip(txt, el){	
	
	$_("stooltip").innerHTML = txt;
	
	var pos = findelpos(el);
	$_("stooltip").style.display = "";
	var tipheight = parseInt($_("stooltip").offsetHeight);
	var tipwidth = parseInt($_("stooltip").offsetWidth);
	//alert(tipheight+" "+tipwidth);
	
	var abody = findelpos($_("abody"));
	var bodyWidth = abody[0] + $_("abody").offsetWidth
	
	if((pos[0] + tipwidth) > bodyWidth){
		pos[0] = pos[0] - (pos[0] + tipwidth - bodyWidth) + 15;
	}
	
	$_("stooltip").style.left = pos[0]+"px";
	$_("stooltip").style.top = (pos[1]-5-tipheight)+"px";
	
	el.onmouseout = function(){
		hidetip();
	};

};

function hidetip(){
	$_("stooltip").style.display = "none";
}

function isNumber(n) {
	if(isNaN(n.value)){
		alert(n.value+\' is not a valid Number\');
		return false;
	}
}

$(document).ready(function() {
	$("#off_sitepad").change(function() {
		if($(this).prop("checked")){
			alert("'.__js('Are you sure you want to disable SitePad Website Builder ? Contact us for more details about SitePad at sales@sitepad.com').'");
		}
	});
});
// ]]></script>';

if(!empty($saved)){
	echo '<div class="container-fluid">
		<div class="alert alert-success text-center">
			<a href="#close" class="close" data-dismiss="alert">&times;</a>
			<i class="fas fa-check sai_icons mr-2"></i>
			 '.__('Your settings were saved successfully').'
		</div>
	</div>';
}

echo '<div id="stooltip" style="display:none; position:absolute; top: 0px; left: 0px; border: 1px solid #CCC; padding: 8px; background: #FFF; z-index:1000;"></div>
<form accept-charset="'.$globals['charset'].'" name="editsettings" method="post" action="" class="form-horizontal">
<div class="container-fluid">';

error_handle($error);

echo '<div class="row">
	<div class="col-12 col-lg-6">';
	
if(!defined('SOFTRESELLER')){
	echo '<div class="sai-card p-3">
	<div class="sai_main_head">
		<h2 class="sai-heading mb-2">'.__('Software Paths').'</h2>
		<hr class="sai_main_head_hr"/>
	</div>
	<div class="sai_form">
		<div class="form-group">
			<label for="softpath" class="sai-label d-block">'.__('$0 Path', array(APP)).'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('This is the path where all files excluding the various scripts are located').'</span>
			<input type="text" name="path" class="form-control" id="softpath" value="'.aPOSTval('path', $globals['path']).'" />
		</div>

		<div class="form-group">
			<label for="softscripts" class="sai-label d-block">'.__('Scripts Path').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('This is the path where all software/scripts are located').'</span>
			<input type="text" name="softscripts" class="form-control" id="softscripts" value="'.aPOSTval('softscripts', $globals['softscripts']).'" />
		</div>

		<p><input type="submit" class="flat-butt" name="editsettings" value="'.__('Edit Settings').'"/></p>
	</div>
</div><br />';
}
	echo '<div class="sai-card p-3">
	<div class="sai_main_head">
		<h2 class="sai-heading mb-2">'.__('Rebranding Settings').'</h2>
		<hr class="sai_main_head_hr"/>
	</div>
	<div class="sai_form">
		<div class="form-group">	
			<label for="sn" class="sai-label d-block">'.__('Site Name').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('The name of the server or company using $0. It will appear in many pages of the $0 installer', array(APP)).'</span>
			<input type="text" name="sn" id="sn" class="form-control" value="'.aPOSTval('sn', $globals['sn']).'" />
		</div>';

		if(!defined('SOFTRESELLER') && method_exists($softpanel, 'register_wordpress_manager')){
			echo '
			<div class="form-group">
				<label class="sai-label" for="wordpress_manager_title">'.__('WordPress Manager').'</label>
				<span class="sai_exp2 d-block mb-2">'.__('This will set a desired name for your WordPress Manager icon in control panel').'</span>
				<input type="text" name="wordpress_manager_title" id="wordpress_manager_title" class="form-control" value="'.aPOSTval('wordpress_manager_title', @$globals['wordpress_manager_title']).'" />
			</div>';
		}
		
		echo '

		<div class="form-group">
			<label for="logo_url" class="sai-label d-block">'.__('Logo URL').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If empty the $0 logo will be shown.', array(APP)).'</span>
			<input type="text" name="logo_url" class="form-control" id="logo_url" value="'.aPOSTval('logo_url', $globals['logo_url']).'" />
		</div>
	
		<div class="form-group">
			<label for="demo_logo" class="sai-label d-block">'.__('Logo URL For Scripts Demo').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If empty the $0 logo will be shown, recommended dimension for the logo Width:150, Height:45', array(APP)).'</span>
			<input type="text" name="demo_logo" class="form-control" id="demo_logo" value="'.aPOSTval('demo_logo', $globals['demo_logo']).'" />		
		</div>
	
		<div class="form-group">
			<label for="demo_logo_url" class="sai-label d-block">'.__('Custom link for Scripts Demo Logo').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If empty the $0 url will be used', array(APP)).'</span>
			<input type="text" name="demo_logo_url" class="form-control" id="demo_logo_url" value="'.aPOSTval('demo_logo_url', $globals['demo_logo_url']).'" />
		</div>
	
		<div class="form-group">
			<label for="favicon_logo" class="sai-label d-block">'.__('Favicon logo URL').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If empty the $0 favicon will be shown in Enduser Panel', array(APP)).'</span>
			<input type="text" name="favicon_logo" class="form-control" id="favicon_logo" value="'.aPOSTval('favicon_logo', $globals['favicon_logo']).'" />
		</div>
		
		<p><input type="submit" class="flat-butt " name="editsettings" value="'.__('Edit Settings').'"/></p>
	</div>
</div><br />

<div class="sai-card p-3">
	<div class="sai_main_head">
		<h2 class="sai-heading mb-2">'.__('General Settings').'</h2>
		<hr class="sai_main_head_hr"/>
	</div>
	<div class="sai_form">';
		
	if(!defined('SOFTRESELLER')){
		
		echo '<div class="form-group">
			<input type="checkbox" name="is_vps" id="is_vps" '.POSTchecked('is_vps', $globals['is_vps']).' />	
			<label for="is_vps" class="sai-label">'.__('Is VPS').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If this server is a VPS then please check this box.').'</span>
		</div>

		<div class="form-group">
			<label for="cookie_name" class="sai-label d-block">'.__('Cookie Name').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('The name of the cookie that will be stored on browsers.').'</span>
			<input type="text" name="cookie_name" id="cookie_name" class="form-control" value="'.aPOSTval('cookie_name', $globals['cookie_name']).'" />
		</div>
		
		<div class="form-group">
			<label for="chmod_files" class="sai-label d-block">'.__('CHMOD Files').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('This is useful if you have suPHP installed and $0 is unable to detect it. Leave blank if unsure.', array(APP)).' '.(empty($suphp) ? '' : '<b>('.__('suPHP Detected').')</b>').'</span>
			<input type="text" name="chmod_files" id="chmod_files" class="form-control"  value="'.aPOSTval('chmod_files', $globals['chmod_files']).'" />
		</div>
		
		<div class="form-group">
			<label for="chmod_dir" class="sai-label d-block">'.__('CHMOD Directories').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('This is useful if you have suPHP installed and $0 is unable to detect it. Leave blank if unsure.', array(APP)).' '.(empty($suphp) ? '' : '<b>('.__('suPHP Detected').')</b>').'</span>
			<input type="text" name="chmod_dir" id="chmod_dir" class="form-control" value="'.aPOSTval('chmod_dir', $globals['chmod_dir']).'" />
		</div>
		
		<div class="form-group">
			<label for="chmod_conf_file" class="sai-label d-block">'.__('CHMOD Config files').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('Config files of scripts will be CHMOD to this value. The default is 0644. (Dont edit / leave blank if you dont know!)').'</span>
			<input type="text" name="chmod_conf_file" id="chmod_conf_file" class="form-control" value="'.aPOSTval('chmod_conf_file', @$globals['chmod_conf_file']).'" />
		</div>
		
		<div class="form-group">
			<label for="footer_link" class="sai-label d-block">'.__('Footer Link').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('When someone installs a Script, this link / text will be inserted in the footer of that installation').'</span>
			<input type="text" name="footer_link" id="footer_link" class="form-control" size="20" value="'.aPOSTval('footer_link', @$globals['footer_link']).'" />
		</div>';
	}

	if($globals['softpanel'] == 'directadmin' && !defined('SOFTRESELLER')){
		echo '<div class="form-group">
			<label for="remote_mysql" class="sai-label d-block">'.__('Remote Mysql Hostname').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If you wish to use remote mysql, specify the Remote Mysql Hostname or IP').'</span>
			<input type="text" name="remote_mysql" id="remote_mysql" class="form-control" size="20" value="'.aPOSTval('remote_mysql', @$globals['remote_mysql']).'" />
		</div>';
	}	
		
	if(!defined('SOFTRESELLER')){
		echo '<div class="form-group">
			<label for="soft_email" class="sai-label d-block">'.__('Admin Email Address').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('The email address to which the CRON activities and other admin related emails are sent to.').'</span>
			<input type="text" name="soft_email" id="soft_email" class="form-control" size="30" value="'.aPOSTval('soft_email', $globals['soft_email']).'" />
		</div>';
	}
		
	echo '<div class="form-group">
		<label for="from_email" class="sai-label d-block">'.__('From Email Address').'</label>
		<span class="sai_exp2 mb-1 d-block">'.__('The email address for the FROM headers.').'</span>
		<input type="text" name="from_email" id="from_email" size="30" class="form-control" value="'.aPOSTval('from_email', $globals['from_email']).'" />
	</div>
		
	<div class="form-group">
		<label for="language" class="sai-label d-block">'.__('Choose Language').'</label>
		<span class="sai_exp2 mb-1 d-block">'.__('Choose your preferred language').'</span>
		<select name="language" id="language" class="form-control">';
		foreach($langs as $k => $v){
			echo '<option value="'.$v.'" '.(empty($_POST['language']) && $globals['language'] == $v ? 'selected="selected"' : (@trim($_POST['language']) == $v ? 'selected="selected"' : '') ).'>'._ucfirst($v).'</option>';
		}
		echo '</select>
	</div>
		
	<div class="form-group">
		<label for="default_protocol" class="sai-label d-block">'.__('Choose Protocol').'</label>
		<span class="sai_exp2 mb-1 d-block">'.__('Choose your preferred protocol. It will be selected by default for enduser.').'</span>
		<select name="default_protocol" id="default_protocol" class="form-control">';
		foreach($protocols as $pk => $pv){
			echo '<option value="'.$pk.'" '.($globals['default_protocol'] == $pk ? 'selected="selected"' : '').'>'.$pv.'</option>';
		}
		echo '</select>
	</div>
		
	<div class="form-group">
		<label class="sai-label d-block">'.__('Disable Protocol').'</label>
		<span class="sai_exp2 mb-1 d-block">'.__('If selected, the protocol will not be displayed to the enduser').'</span>
		<div class="row">';
		foreach($protocols as $pk => $pv){
			echo '<div class="col-6">
				<input type="checkbox" id="off_proto_'.$pk.'" name="off_proto_'.$pk.'" '.POSTchecked('off_proto_'.$pk, @$globals['off_proto_'.$pk]).' /><span class="sai-label ml-1"><label for="off_proto_'.$pk.'" class="sai-label">'.$pv.'</label></span>
			</div>';
		}
	echo'</div>
	</div>
		
	<div class="form-group">
		<label for="theme_folder" class="sai-label d-block">'.__('Choose Theme').'</label>
		<span class="sai_exp2 mb-1 d-block">'.__('The selected theme will be the default theme throughout $0', array(APP)).'</span>
		<select name="theme_folder" id="theme_folder" class="form-control">';
		foreach($skins as $k => $v){
			echo '<option value="'.$v.'" '.(empty($_POST['theme_folder']) && $globals['theme_folder'] == $v ? 'selected="selected"' : (trim($_POST['theme_folder']) == $v ? 'selected="selected"' : '') ).'>'._ucfirst($v).'</option>';	
		}
		echo '</select>
	</div>';
					
	if(!defined('SOFTRESELLER')){
		echo '<div class="form-group">		
		<label class="sai-label">'.__('Default color for Header Footer').'</label>
		<input type="color" name="color" id="default_hf_bg" class="changecolor"/>
		<input type="hidden" name="default_hf_bg" value="'.aPOSTval('default_hf_bg', $globals['default_hf_bg']).'" id="hidden_default_hf_bg">
		<span class="sai_exp2 mb-1 d-block">'.__('This will be the default color for Header, Footer and Left Panel').'</span>
	</div>

	<div class="form-group">		
		<label class="sai-label">'.__('Default color for Category hover').'</label>
		<input type="color" name="color" id="default_cat_hover" class="changecolor"/>
		<input type="hidden" name="default_cat_hover" value="'.aPOSTval('default_cat_hover', $globals['default_cat_hover']).'" id="hidden_default_cat_hover">
		<span class="sai_exp2 mb-1 w-75 d-block">'.__('This will be the default color when the user hovers over the Categories in Left panel').'</span>
	</div>
		
	<div class="form-group">
		<label class="sai-label">'.__('Default color for text in Header Footer').'</label>		
		<input type="color" name="color" id="default_hf_text" class="changecolor"/>
		<input type="hidden" name="default_hf_text" value="'.aPOSTval('default_hf_text', $globals['default_hf_text']).'" id="hidden_default_hf_text">
		<span class="sai_exp2 mb-1 w-75 d-block">'.__('This will be the default color for text in Header, Footer and Left Panel').'</span>
	</div>
	
	<div class="form-group">
		<label class="sai-label">'.__('Default color for script name text in Left panel').'</label>		
		<input type="color" name="color" id="default_scriptname_text" class="changecolor"/>
		<input type="hidden" name="default_scriptname_text" value="'.aPOSTval('default_scriptname_text', $globals['default_scriptname_text']).'" id="hidden_default_scriptname_text">
		<span class="sai_exp2 mb-1 w-75 d-block">'.__('This will be the default color for script name text in Left Panel').'</span>
	</div>';
		
	echo '<div class="form-group">
		<label class="sai-label d-block" for="time_format">'.__('Default Time format').'</label>
		<span class="sai_exp2 mb-1 w-75 d-block">'.__('Choose the default time format. Default : <b>F j, Y, g:i a</b>').'</span>
		<input type="text" id="time_format" name="time_format" class="form-control" size="30" value="'.aPOSTval('time_format', $globals['time_format']).'" />
	</div>

	<div class="form-group">
		<label class="sai-label d-block" for="timezone" >'.__('Timezone').'</label>
		<select name="timezone" style="font-size:12px " id="timezone" class="form-control">
			<option value="0" '.(empty($_POST['timezone']) && empty($globals['timezone']) ? 'selected="selected"' : '').' >'.__('Default').'</option>';
			foreach($timezone_list as $zone => $zone_details){
				echo '<option value="'.$zone.'" '.(POSTval('timezone', $globals['timezone']) === $zone ? 'selected="selected"' : '').' >('.$zone_details['pretty_offset'].') '.$zone_details['display_timezone'].'</option>';
			}
		echo '</select>
	</div>
		
	<div class="form-group">
		<label class="sai-label d-block" for="user_homedir">'.__('Home Directory for users').'</label>
		<span class="sai_exp2 mb-1 d-block">'.__('Enter the home directory, if your home directory is a custom path e.g. /home2').'</span>
		<input type="text" id="user_homedir" name="user_homedir" class="form-control" size="30" value="'.POSTval('user_homedir', $globals['user_homedir']).'" />
	</div>
		
	<div class="form-group">
		<label for="logs_level" class="sai-label d-block">'.__('$0 Logs Level', array(APP)).'</label>
		<span class="sai_exp2 mb-1 d-block">'.__('Selected logs level will be used for error/debug logs. <br />Logs level 4 might contain passwords').'</span>
		<select name="logs_level" id="logs_level" class="form-control">
			<option value="0" '.POSTselect('logs_level', 0, (empty($globals['logs_level']) ? '1' : '0')).'>'.__('Off').'</option>
			<option value="1" '.POSTselect('logs_level', 1, ($globals['logs_level'] == '1' ? '1' : '0')).'>1</option>
			<option value="2" '.POSTselect('logs_level', 2, ($globals['logs_level'] == '2' ? '1' : '0')).'>2</option>
			<option value="3" '.POSTselect('logs_level', 3, ($globals['logs_level'] == '3' ? '1' : '0')).'>3</option>
			<option value="4" '.POSTselect('logs_level', 4, ($globals['logs_level'] == '4' ? '1' : '0')).'>4 ('.__('Detailed Logs').')</option>
		</select>
	</div>';

	if(!aefer() && !ent() && method_exists($softpanel, 'loadvars_cli')){
		
		echo '<div class="form-group">
			<input type="checkbox" id="auto_import_manual_ins" name="auto_import_manual_ins" '.POSTchecked('auto_import_manual_ins', $globals['auto_import_manual_ins']).' />
			<label class="sai-label" for="auto_import_manual_ins">'.__('Auto Import Manual Installations').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If enabled, manual installations done by users will be automatically imported to $0 (every 24 hours).', array(APP)).'</span>	
		</div>';
	}

	if($globals['softpanel'] == 'cpanel' || $globals['softpanel'] == 'plesk'){
		
		echo '<div class="form-group">
			<input type="checkbox" id="off_auto_import_wptoolkit" name="off_auto_import_wptoolkit" '.POSTchecked('off_auto_import_wptoolkit', !$globals['off_auto_import_wptoolkit']).' />
			<label class="sai-label" for="off_auto_import_wptoolkit">'.__('Auto Import WP Toolkit Installations').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If enabled, installations done by users via WP Toolkit will be automatically imported to $0 (every 24 hours)', array(APP)).'</span>	
		</div>';
	}
		
	if(aefer() || ent() || $globals['softpanel'] == 'isp'){
		echo '<div class="form-group">
			<input type="checkbox" id="disable_csrf" name="disable_csrf" '.POSTchecked('disable_csrf', @$globals['disable_csrf']).' />	
			<label class="sai-label" for="disable_csrf">'.__('Disable CSRF').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('This will disable the CSRF security check in Softaculous').'</span>
		</div>';
	}
	
	if($globals['softpanel'] == 'hc'){
		echo '<div class="form-group">
			<input type="text" class="form-control" id="hc_apiurl" name="hc_apiurl" size="30" value="'.aPOSTval('hc_apiurl', htmlizer($globals['hc_apiurl'])).'" />		
			<label class="sai-label" for="hc_apiurl">'.__('Hosting Controller API URL').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('API calls for various tasks such as fetching users list, etc at admin level or in CLI will be performed using this HC API URL. This URL must be a valid API URL accessible from your server and of the format <b>http(s)://IP:PORT</b>').'</span>
		</div>';
	}
		
	if(aefer() || ent()){
		echo '<div class="form-group">
			<input type="checkbox" id="enc_user_pass" name="enc_user_pass" '.POSTchecked('enc_user_pass', @$globals['enc_user_pass']).' />
			<label class="sai-label" for="enc_user_pass">'.__('Encrypt API Pass').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If selected the API Pass for user(s) will be encrypted and stored').'</span>
		</div>

		<div class="form-group">
			<input type="checkbox" id="force_softaculous_on_ssl" name="force_softaculous_on_ssl" '.POSTchecked('force_softaculous_on_ssl', @$globals['force_softaculous_on_ssl']).' />	
			<label class="sai-label" for="force_softaculous_on_ssl">'.__('Force $0 to run on SSL(HTTPS)', array(APP)).'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If enabled, $0 will redirect non-ssl page request to HTTPS', array(APP)).'</span>
		</div>';
	}
	
	}
		
	echo '<p><input type="submit" class="flat-butt " name="editsettings" value="'.__('Edit Settings').'"/></p>
	</div>
</div><br/>

<div class="sai-card p-3">
	<div class="sai_main_head">
		<h2 class="sai-heading mb-2">'.__('SitePad Settings').'</h2>
		<hr class="sai_main_head_hr"/>
	</div>
	
	<div class="sai_form">
		<div class="form-group">
			<input type="checkbox" id="off_sitepad" name="off_sitepad"  '.POSTchecked('off_sitepad', @$globals['off_sitepad']).' />	
			<label class="sai-label" for="off_sitepad">'.__('Turn Off SitePad Website Builder').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('This will disable SitePad for all your users<br /><b>Note:</b> SitePad is based on Freemium model. <a href="mailto:sales@sitepad.com">More details</a>').'</span>
		</div>
		
		<div class="form-group">
			<input type="checkbox" name="hide_sitepad" id="hide_sitepad" '.POSTchecked('hide_sitepad', @$globals['hide_sitepad']).' />	
			<label class="sai-label" for="hide_sitepad">'.__('Hide SitePad Website Builder').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('This will disable SitePad for the users who have not used SitePad but will leave SitePad enabled for users who have used SitePad').'</span>			
		</div>
		
		<div class="form-group">
			<label for="sm_brand" class="sai-label d-block">'.__('Brand Name').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('A single word for the Brand Name. If empty the default value will be : SitePad').'</span>
			<input type="text" name="sm_brand" id="sm_brand" class="form-control" value="'.aPOSTval('sm_brand', $globals['sm_brand']).'" />
		</div>
		
		<div class="form-group">
			<label for="sm_sitename" class="sai-label d-block">'.__('Site Name').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('The name of the server or company using SitePad. It will appear in many pages of the SitePad Website Builder').'</span>
			<input type="text" name="sm_sitename" id="sm_sitename" class="form-control" value="'.aPOSTval('sm_sitename', $globals['sm_sitename']).'" />
		</div>
		
		<div class="form-group">
			<label for="sm_brand_editor" class="sai-label d-block">'.__('Editor Name').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('The name of the editor to be shown. If empty the default value will be : SitePad Editor').'</span>
			<input type="text" name="sm_brand_editor" id="sm_brand_editor" class="form-control" value="'.aPOSTval('sm_brand_editor', $globals['sm_brand_editor']).'" />
		</div>

		<div class="form-group">
			<label for="sm_logo_url" class="sai-label d-block">'.__('Logo URL').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('It should be a 100 x 100 pixels transparent PNG image. If empty the SitePad logo will be shown').'</span>		
			<input type="text" name="sm_logo_url" id="sm_logo_url" class="form-control" value="'.aPOSTval('sm_logo_url', $globals['sm_logo_url']).'" />
		</div>
		
		<div class="form-group">
			<label for="sm_brand_url" class="sai-label d-block">'.__('Website URL').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('The URL to show the users for this Website Builder. If empty the default value will be : https://sitepad.com').'</span>		
			<input type="text" name="sm_brand_url" id="sm_brand_url" class="form-control" value="'.aPOSTval('sm_brand_url', $globals['sm_brand_url']).'" />
		</div>
				
		<div class="form-group">
			<label for="host_sm" class="sai-label d-block">'.__('Custom Server Host').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('You can create a CNAME record to point to <a href="https://sitepad.com/docs/admin-old/servers/" target="_blank">our Servers</a>. Or you can simply use our servers hostname. If empty SitePad will use default server host for user').'</span>
			<input type="text" name="host_sm" id="host_sm" class="form-control" size="30" value="'.aPOSTval('host_sm', $globals['host_sm']).'" />
		</div>

		<div class="form-group">
			<label for="sm_brand_demos" class="sai-label d-block">'.__('Themes Demos URL').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('You can create a CNAME record to point to <b>demos.sitepad.com</b> <br />If empty SitePad will use default demos server for displaying themes demos').'</span>
			<input type="text" name="sm_brand_demos" id="sm_brand_demos" class="form-control" size="30" value="'.aPOSTval('sm_brand_demos', $globals['sm_brand_demos']).'" />
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="sm_no_demos" name="sm_no_demos" '.POSTchecked('sm_no_demos', $globals['sm_no_demos']).' />	
			<label class="sai-label" for="sm_no_demos">'.__('Disable Themes Demos').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('Select this checkbox if you want to disable the themes demos for the user').'</span>			
		</div>

		<div class="form-group">
			<input type="checkbox" id="sm_no_recent_themes" name="sm_no_recent_themes" '.POSTchecked('sm_no_recent_themes', $globals['sm_no_recent_themes']).' />	
			<label class="sai-label" for="sm_no_recent_themes">'.__('Disable Recent Themes').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('Select this checkbox if you want to disable the recently added themes section on the enduser Dashboard').'</span>
		</div>

		<div class="form-group">
			<label for="sm_ftp_host" class="sai-label d-block">'.__('FTP Host').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('You can specify the FTP Host/IP that SitePad should use to connect while publishing files to your server. By default server IP will be used').'</span>
			<input type="text" name="sm_ftp_host" id="sm_ftp_host" class="form-control" size="30" value="'.aPOSTval('sm_ftp_host', $globals['sm_ftp_host']).'" />
		</div>
		
		<div class="form-group">
			<label for="sm_ftp_port" class="sai-label d-block">'.__('FTP Port').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('You can specify the FTP Port that SitePad should use to connect while publishing files to your server. By default 21 will be used').'</span>
			<input type="text" name="sm_ftp_port" id="sm_ftp_port" class="form-control" size="30" value="'.aPOSTval('sm_ftp_port', $globals['sm_ftp_port']).'" />
		</div>				
		<p><input type="submit" class="flat-butt " name="editsettings" value="'.__('Edit Settings').'"/></p>
	</div>
</div><br />';
		
if(!defined('SOFTRESELLER')){
	// PFX Settings will be here
	if(!empty($globals['lictype'])){
		echo '<div class="sai-card p-3">
		<div class="sai_main_head mb-2">
			<h2 class="sai-heading mb-2">'.__('PopularFX Settings').'</h2>
			<hr class="sai_main_head_hr"/>
		</div>
		<div class="sai_form">
			<div class="form-group">
				<input type="checkbox" id="eu_enable_themes" name="eu_enable_themes" '.POSTchecked('eu_enable_themes', @$globals['eu_enable_themes']).' />	
				<label class="sai-label" for="eu_enable_themes">'.__('Enable Free Themes').'</label>
				<span class="sai_exp2 mb-1 d-block">'.__('If checked then endusers will get an option to select and install free themes while installing scripts like WordPress').'</span>
			</div>
		</div>
	</div><br/>';
	}	
		
	echo '<div class="sai-card p-3">
	<div class="sai_main_head mb-2">
		<h2 class="sai-heading mb-2">'.__('Update Settings').'</h2>
		<hr class="sai_main_head_hr"/>
	</div>
	<div class="sai_form">
		<div class="form-group">
		  <div class = "row">
		   <div class = "col-md-12">
			<label class="sai-label d-block">'.__('Auto Update $0', array(APP)).'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If enabled $0 will automatically update itself to the latest version. <br />The <b>Stable</b> branch is launched after the Release Candidate has been thorughly tested. <br />The <b>Release Candidate</b> branch contains the latest version and features.', array(APP)).'</span>
		   </div>
		   <div class = "col-md-12">
			<span class="d-block mb-0"><input type="radio" name="update" value="0" '.POSTradio('update', 0, $globals['update']).' /> <label class="sai-label mb-1">'.__('Never Update').'</label></span>
			<span class="d-block mb-0"><input type="radio" name="update" value="1" '.POSTradio('update', 1, $globals['update']).' /> <label class="sai-label mb-1">'.__('Stable (Recommended)').'</label></span> 
			<span class="d-block mb-0"><input type="radio" name="update" value="2" '.POSTradio('update', 2, $globals['update']).' /> <label class="sai-label mb-1">'.__('Release Candidate (Experimental!)').'</label></span>
		   </div>
		  </div>
		</div>';
		
		echo '<div class="form-group">
			<input type="checkbox" id="update_softs" name="update_softs" '.POSTchecked('update_softs', $globals['update_softs']).' />
			<label class="sai-label" for="update_softs">'.__('Auto Update Scripts').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If enabled, the various scripts or software will be automatically updated to their latest versions').'</span>		
		</div>

		<div class="form-group">
			<input type="checkbox" id="add_softs" name="add_softs" '.POSTchecked('add_softs', $globals['add_softs']).' />
			<label class="sai-label" for="add_softs">'.__('Auto Add New Scripts').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If enabled, new scripts or software will be added during the maintenance cron job. RECOMMENDED').'</span>	
		</div>
			
		<div class="form-group">
			<input type="checkbox" id="email_update" name="email_update" '.POSTchecked('email_update', $globals['email_update']).' />
			<label class="sai-label" for="email_update">'.__('Notify Updates via Email').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('Will send emails when $0 upgrades are available or Auto Upgrade is performed', array(APP)).'</span>	
		</div>
			
		<div class="form-group">
			<input type="checkbox" id="email_update_softs" name="email_update_softs" '.POSTchecked('email_update_softs', $globals['email_update_softs']).' />	
			<label class="sai-label" for="email_update_softs">'.__('Notify Script Updates via Email').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('Will send emails when scripts or software updates are available or auto update of scripts or software is performed').'</span>		
		</div>';
			
		echo '<div class="form-group">			
			<label for="cron_time" class="sai-label d-block">'.__('Updates Cron Job').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__("The cron job time to check for available updates. Don't change this if you are unaware of what cron jobs are").'</span>
			<input type="text" name="cron_time" id="cron_time" class="form-control" size="30" value="'.aPOSTval('cron_time', $globals['cron_time']).'" />
		</div>
			
		<div class="form-group">
			<label for="php_bin" class="sai-label d-block" >'.__('PHP Binary').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('This is the binary that will be used for the CRON Job and also other purposes. If empty then <b>/usr/bin/php</b> will be used. Please note that the <b>PHP binary should be a CLI binary</b>.').'</span>	
			<input type="text" class="form-control" id="php_bin" name="php_bin" size="30" value="'.aPOSTval('php_bin', htmlizer($globals['php_bin'])).'" />
		</div>

		<p><input type="submit" class="flat-butt " name="editsettings" value="'.__('Edit Settings').'"/></p>
	</div>
</div><br />

<div class="sai-card p-3">
	<div class="sai_main_head mb-2">
		<h2 class="sai-heading mb-2">'.__('Enduser Remove Options').'</h2>
		<hr class="sai_main_head_hr"/>
	</div>
	<div class="sai_form">
		<div class="form-group">
			<input type="checkbox" id="remove_dir" name="remove_dir" '.POSTchecked('remove_dir', $globals['remove_dir']).' />
			<label for="remove_dir" class="sai-label">'.__('Hide Remove Directory Option').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If selected, Installation Directory will always be deleted when an installation is removed').'</span>
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="remove_db" name="remove_db" '.POSTchecked('remove_db', $globals['remove_db']).' />
			<label for="remove_db" class="sai-label">'.__('Hide Remove Database and Database User Option').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If selected, Database and Database User will always be deleted when an installation is removed').'</span>			
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="remove_datadir" name="remove_datadir" '.POSTchecked('remove_datadir', $globals['remove_datadir']).' />
			<label for="remove_datadir" class="sai-label">'.__('Hide Remove Data Directory Option').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If selected, Data Directory will always be deleted when an installation is removed').'</span>
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="remove_wwwdir" name="remove_wwwdir" '.POSTchecked('remove_wwwdir', $globals['remove_wwwdir']).' />
			<label for="remove_wwwdir" class="sai-label">'.__('Hide Remove WWW Directory Option').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If selected, WWW Directory will always be deleted when an installation is removed').'</span>
		</div>
		
		<p><input type="submit" class="flat-butt " name="editsettings" value="'.__('Edit Settings').'"/></p>
	</div>
</div><br />

<div class="sai-card p-3">
	<div class="sai_main_head mb-2">
		<h2 class="sai-heading mb-2">'.__('Privacy Settings').'</h2>
		<hr class="sai_main_head_hr"/>
	</div>
	<div class="sai_form">
		<div class="form-group">
			<input type="checkbox" id="off_ins_stats" name="off_ins_stats" '.POSTchecked('off_ins_stats', $globals['off_ins_stats']).' />	
			<label class="sai-label" for="off_ins_stats" >'.__('Disable Installation Statistics').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('This will disable sending anonymous installation statistics to Softaculous. We collect only the count of installations. We do not collect or store any other information related to the installation (url, path, etc)').'</span>
		</div>
		<div class="form-group">
			<input type="checkbox" id="off_os_stats" name="off_os_stats" '.POSTchecked('off_os_stats', $globals['off_os_stats']).' />	
			<label class="sai-label" for="off_os_stats" >'.__('Disable OS Info').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('This will disable sending OS details to Softaculous. This is used to deliver updates based on compatibility with your OS').'</span>
		</div>
		<p><input type="submit" class="flat-butt " name="editsettings" value="'.__('Edit Settings').'"/></p>
	</div>
</div><br />

<div class="sai-card p-3">
	<div class="sai_main_head mb-2">
		<h2 class="sai-heading mb-2">'.__('Social Media Settings').'</h2>
		<hr class="sai_main_head_hr"/>
	</div>
	<div class="sai_form">
		<div class="form-group">
			<input type="checkbox" id="install_tweet_off" name="install_tweet_off" '.POSTchecked('install_tweet_off', $globals['install_tweet_off']).' />	
			<label class="sai-label" for="install_tweet_off" >'.__('Turn off Tweet for New Installations').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If checked, the Tweet option will not be shown after a new installation').'</span>
		</div>
		
		<div class="form-group">
			<label for="install_tweet" class="sai-label d-block">'.__('Tweet Message for New Installations').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('Custom Tweet Message for New Installations').'</span>
			<span class="sai_exp2 mb-1 d-block" style="cursor:pointer;" onmouseover="showtip(\''.__js('[[SCRIPTNAME]] - Use this for script name <br />[[TYPE]] - Use this for script type Eg: PHP, PERL, etc <br />[[softurl]] - Use this for the URL of installation <br />[[cat]] - Use this for the script category Eg: Blog, CMS, etc <br />[[ver]] - Use this for the version of script installed <br />').'\', this)">'.__('List of variables for Tweet message').'</span>
			<input type="text" name="install_tweet" id="install_tweet" class="form-control" size="30" value="'.aPOSTval('install_tweet', (!empty($globals['install_tweet']) ? $globals['install_tweet'] : __('I just installed #[[SCRIPTNAME]] on [[softurl]] via #[[APP]] #[[TYPE]]'))).'" />
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="upgrade_tweet_off" name="upgrade_tweet_off" '.POSTchecked('upgrade_tweet_off', $globals['upgrade_tweet_off']).' />	
			<label class="sai-label" for="upgrade_tweet_off">'.__('Turn off Tweet for Upgrade Installation').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If checked, the Tweet option will not be shown after upgrading an installation').'</span>
		</div>
		
		<div class="form-group">
			<label for="upgrade_tweet" class="sai-label d-block">'.__('Tweet Message for Upgrade Installation').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('Custom tweet message for Upgrade Installation').'</span>
			<span class="sai_exp2 mb-1 d-block" style="cursor:pointer;" onmouseover="showtip(\''.__js('[[SCRIPTNAME]] - Use this for script name <br />[[TYPE]] - Use this for script type Eg: PHP, PERL, etc <br />[[softurl]] - Use this for the URL of installation <br />[[cat]] - Use this for the script category Eg: Blog, CMS, etc <br />[[ver]] - Use this for the version of script installed <br />').'\', this)">'.__('List of variables for Tweet message').'</span>
			<input type="text" name="upgrade_tweet" id="upgrade_tweet" class="form-control" size="30" value="'.aPOSTval('upgrade_tweet', (!empty($globals['upgrade_tweet']) ? $globals['upgrade_tweet'] : __('I just upgraded #[[SCRIPTNAME]] on [[softurl]] via #[[APP]] #[[TYPE]]'))).'" />
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="clone_tweet_off" name="clone_tweet_off" '.POSTchecked('clone_tweet_off', $globals['clone_tweet_off']).' />	
			<label class="sai-label" for="clone_tweet_off">'.__('Turn off Tweet for Clone Installation').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If checked, the Tweet option will not be shown after cloning an installation').'</span>
		</div>

		<div class="form-group">
			<label for="clone_tweet" class="sai-label d-block">'.__('Tweet Message for Clone Installation').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('Custom tweet message for Clone Installation').'</span>
			<span class="sai_exp2 mb-1 d-block" style="cursor:pointer;" onmouseover="showtip(\''.__js('[[SCRIPTNAME]] - Use this for script name <br />[[TYPE]] - Use this for script type Eg: PHP, PERL, etc <br />[[softurl]] - Use this for the URL of installation <br />[[cat]] - Use this for the script category Eg: Blog, CMS, etc <br />[[ver]] - Use this for the version of script installed <br />').'\', this)">'.__('List of variables for Tweet message').'</span>
			<input type="text" name="clone_tweet" class="form-control" id="clone_tweet" size="30" value="'.aPOSTval('clone_tweet', (!empty($globals['clone_tweet']) ? $globals['clone_tweet'] : __('I just cloned #[[SCRIPTNAME]] on [[softurl]] via #[[APP]] #[[TYPE]]'))).'" />
		</div>
		<div class="form-group">
			<input type="checkbox" id="staging_tweet_off" name="staging_tweet_off" '.POSTchecked('staging_tweet_off', $globals['staging_tweet_off']).' />	
			<label class="sai-label" for="staging_tweet_off">'.__('Turn off Tweet for Staging Installation').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If checked, the Tweet option will not be shown after Staging an installation').'</span>
		</div>

		<div class="form-group">
			<label for="staging_tweet" class="sai-label d-block">'.__('Tweet Message for Staging Installation').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('Custom tweet message for Staging Installation').'</span>
			<span class="sai_exp2 mb-1 d-block" style="cursor:pointer;" onmouseover="showtip(\''.__js('[[SCRIPTNAME]] - Use this for script name <br />[[TYPE]] - Use this for script type Eg: PHP, PERL, etc <br />[[softurl]] - Use this for the URL of installation <br />[[cat]] - Use this for the script category Eg: Blog, CMS, etc <br />[[ver]] - Use this for the version of script installed <br />').'\', this)">'.__('List of variables for Tweet message').'</span>
			<input type="text" name="staging_tweet" class="form-control" id="staging_tweet" size="30" value="'.aPOSTval('staging_tweet', (!empty($globals['staging_tweet']) ? $globals['staging_tweet'] : __('I just created a staging installation of #[[SCRIPTNAME]] on [[softurl]] via #[[APP]] #[[TYPE]]'))).'" />
		</div>
		<div class="form-group">
			<input type="checkbox" id="pushtolive_tweet_off" name="pushtolive_tweet_off" '.POSTchecked('pushtolive_tweet_off', $globals['pushtolive_tweet_off']).' />	
			<label class="sai-label" for="pushtolive_tweet_off">'.__('Turn off Tweet for Push to live Installation').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If checked, the Tweet option will not be shown after Pushing an installation to live').'</span>
		</div>

		<div class="form-group">
			<label for="pushtolive_tweet" class="sai-label d-block">'.__('Tweet Message for Push to live Installation').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('Custom tweet message for Push to live Installation').'</span>
			<span class="sai_exp2 mb-1 d-block" style="cursor:pointer;" onmouseover="showtip(\''.__js('[[SCRIPTNAME]] - Use this for script name <br />[[TYPE]] - Use this for script type Eg: PHP, PERL, etc <br />[[softurl]] - Use this for the URL of installation <br />[[cat]] - Use this for the script category Eg: Blog, CMS, etc <br />[[ver]] - Use this for the version of script installed <br />').'\', this)">'.__('List of variables for Tweet message').'</span>
			<input type="text" name="pushtolive_tweet" class="form-control" id="pushtolive_tweet" size="30" value="'.aPOSTval('pushtolive_tweet', (!empty($globals['pushtolive_tweet']) ? $globals['pushtolive_tweet'] : __('I just pushed my staging #[[SCRIPTNAME]] to live on [[softurl]] via #[[APP]] #[[TYPE]]'))).'" />
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="restore_template_tweet_off" name="restore_template_tweet_off" '.POSTchecked('restore_template_tweet_off', $globals['restore_template_tweet_off']).' />	
			<label class="sai-label" for="restore_template_tweet_off">'.__('Turn off Tweet for Restored Template').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('If checked, the Tweet option will not be shown after restoring a template').'</span>
		</div>

		<div class="form-group">
			<label for="restore_template_tweet" class="sai-label d-block">'.__('Tweet Message for Restore Template').'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('Custom tweet message for Restore Template').'</span>
			<span class="sai_exp2 mb-1 d-block" style="cursor:pointer;" onmouseover="showtip(\''.__js('[[SCRIPTNAME]] - Use this for script name <br />[[TYPE]] - Use this for script type Eg: PHP, PERL, etc <br />[[softurl]] - Use this for the URL of installation <br />[[cat]] - Use this for the script category Eg: Blog, CMS, etc <br />[[ver]] - Use this for the version of script installed <br />').'\', this)">'.__('List of variables for Tweet message').'</span>
			<input type="text" name="restore_template_tweet" class="form-control" id="restore_template_tweet" size="30" value="'.aPOSTval('restore_template_tweet', (!empty($globals['restore_template_tweet']) ? $globals['restore_template_tweet'] : __('I just restored a #[[SCRIPTNAME]] template on [[softurl]] via #[[APP]] #[[TYPE]]'))).'" />
		</div>
		<p><input type="submit" class="flat-butt " name="editsettings" value="'.__('Edit Settings').'"/></p>
	</div>
</div><br />

<div class="sai-card p-3">
	<div class="sai_main_head mb-2">
		<h2 class="sai-heading mb-2">'.__('Disable $0', array(APP)).'</h2>
		<hr class="sai_main_head_hr"/>
	</div>
	<div class="sai_form">
		<div class="form-group">
			<input type="checkbox" id="off" name="off" '.POSTchecked('off', $globals['off']).' />
			<label class="sai-label" for="off">'.__('Turn $0 Off', array(APP)).'</label>
			<span class="sai_exp2 mb-1 d-block">'.__('This will disable $0 and users will not be able to use it!', array(APP)).'</span>
		</div>
		
		<div class="form-group">
			<label for="off_subject" class="sai-label d-block">'.__('Switch Off Subject').'</label><br />
			<input type="text" name="off_subject" class="form-control" id="off_subject" size="30" value="'.aPOSTval('off_subject', $globals['off_subject']).'" />
		</div>
		
		<div class="form-group">
			<label for="off_message" class="sai-label d-block">'.__('Switch Off Message').'</label><br />
			<textarea name="off_message" class="form-control" cols="30" rows="6">'.aPOSTval('off_message', $globals['off_message']).'</textarea>
		</div><br />
		<p><input type="submit" class="flat-butt " name="editsettings" value="'.__('Edit Settings').'"/></p>
	</div><br />
</div>';
}
	
echo '</div>
	
<div class="col-12 col-lg-6">
	<div class="sai-card p-3">
		<div class="sai_main_head mb-2">
			<h2 class="sai-heading mb-2">'.__('End User Panel Settings').'</h2>
			<hr class="sai_main_head_hr"/>
		</div>
		<div class="sai_form">
			<div class="form-group">
				<input type="checkbox" id="no_prefill"  name="no_prefill" '.POSTchecked('no_prefill', @$globals['no_prefill']).' />
				<label class="sai-label" for="no_prefill">'.__("Don't Prefill Directory Name").'</label>
				<span class="sai_exp2 d-block mb-1">'.__("Don't prefill the directory name with the scripts name by default.").'</span>				
			</div>
		
			<div class="form-group">
				<input type="checkbox" id="no_indir" name="no_indir" '.POSTchecked('no_indir', @$globals['no_indir']).' />		
				<label class="sai-label" for="no_indir">'.__('Hide <b>In Directory</b> Field').'</label>
				<span class="sai_exp2 d-block mb-1">'.__('If selected, then In Directory field will be hidden on installation form and the users will be able to install scripts only on domain root not in subdirectory.').'</span>
			</div>
		
			<div class="form-group">
				<input type="checkbox" id="random_username" name="random_username" '.POSTchecked('random_username', @$globals['random_username']).' />	
				<label class="sai-label" for="random_username">'.__('Generate Random Username for users').'</label>
				<span class="sai_exp2 d-block mb-1">'.__('If checked then randomly generated admin usernames will be made during an installation.').'</span>
			</div>
		
			<div class="form-group">
				<input type="checkbox" id="random_pass" name="random_pass" '.POSTchecked('random_pass', @$globals['random_pass']).' />
				<label class="sai-label" for="random_pass">'.__('Generate Random Password for users').'</label>
				<span class="sai_exp2 d-block mb-1">'.__('If checked then randomly generated admin passwords will be made during an installation.').'</span>				
			</div>
			
			<div class="form-group">
				<input type="checkbox" id="random_dbprefix" name="random_dbprefix" '.POSTchecked('random_dbprefix', @$globals['random_dbprefix']).' />
				<label class="sai-label" for="random_dbprefix">'.__('Generate Random Database Prefix for users').'</label>
				<span class="sai_exp2 d-block mb-1">'.__('If checked then a randomly generated Database Prefix will be made during an installation.').'</span>
			</div>';
		
		if(!defined('SOFTRESELLER')){
			echo '<div class="form-group">
				<input type="checkbox" id="empty_username" name="empty_username" '.POSTchecked('empty_username', @$globals['empty_username']).' />	
				<label class="sai-label" for="empty_username">'.__('Empty Username').'</label>
				<span class="sai_exp2 d-block mb-1">'.__('If checked then the ADMIN USERNAME field will be left blank.').'</span>
			</div>

			<div class="form-group">
				<input type="checkbox" id="empty_pass" name="empty_pass" '.POSTchecked('empty_pass', @$globals['empty_pass']).' />	
				<label class="sai-label" for="empty_pass">'.__('Empty Password').'</label>
				<span class="sai_exp2 d-block mb-1">'.__('If checked then the PASSWORD field will be left blank.').'</span>
			</div>
			
			<div class="form-group">
				<input type="checkbox" id="empty_email" name="empty_email" '.POSTchecked('empty_email', @$globals['empty_email']).' />	
				<label class="sai-label" for="empty_email">'.__('Empty Email').'</label>
				<span class="sai_exp2 d-block mb-1">'.__('If checked then the EMAIL field on the script install form will be left blank.').'</span>
			</div>
			
			<div class="form-group">
				<input type="checkbox" id="gzip" name="gzip" '.POSTchecked('gzip', $globals['gzip']).' />
				<label class="sai-label" for="gzip">'.__('Compress Output').'</label>
				<span class="sai_exp2 d-block mb-1">'.__('This will compress output and it saves a lot of bandwidth.').'</span>
			</div>';
		}
	
if(!empty($softpanel->native_ui)){
	echo '<div class="form-group">
		<input type="checkbox" id="panel_hf" name="panel_hf" size="30" '.POSTchecked('panel_hf', @$globals['panel_hf']).' />		
		<label class="sai-label" for="panel_hf">'.__("Show Softaculous in control panel's native UI").'</label><br />
		<span class="sai_exp2 d-block mb-1">'.__("If this is enabled then Softaculous will be shown in control panel's native UI.").'</span>
	</div>';
}

if(!defined('SOFTRESELLER')){
	echo '<div class="form-group">
		<input type="checkbox" id="show_cscript_in_top" name="show_cscript_in_top" '.POSTchecked('show_cscript_in_top', @$globals['show_cscript_in_top']).' />
		<label class="sai-label" for="show_cscript_in_top">'.__('Show custom script(s) logo in TOP scripts.').'</label>
		<span class="sai_exp2 d-block mb-1">'.__('If enabled your custom script(s) logo will be displayed in the TOP scripts.').'</span>			
	</div>';
		
	if(!empty($softpanel->user_mod_dir)){
		echo '<div class="form-group">
			<input type="checkbox" id="user_mod_dir" name="user_mod_dir" '.POSTchecked('user_mod_dir', $globals['user_mod_dir']).' />
			<label class="sai-label" for="user_mod_dir">'.__('Use USER MOD DIR').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('Users can install scripts on http://IP/~user').'</span>
		</div>';
		
		if($globals['softpanel'] == 'cpanel'){
			echo '<div class="form-group">
				<input type="checkbox" id="nat_config" name="nat_config" '.POSTchecked('nat_config', $globals['nat_config']).' />			
				<label class="sai-label" for="nat_config">'.__('NAT Configuration').'</label>
				<span class="sai_exp2 d-block mb-1">'.__('Select this option if you are using NAT configuration on your server').'</span>
			</div>';
		}
	}
	
	echo '<div class="form-group">
			<label for="pass_strength" class="sai-label d-block">'.__('Set Minimum Password Strength').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('If set, then the password strength must be more than the defined value').'</span>
			<input type="text" name="pass_strength" id="pass_strength" class="form-control" size="30" value="'.aPOSTval('pass_strength', $globals['pass_strength']).'" />
		</div>
		
		<div class="form-group">			
			<label for="admin_prefix" class="sai-label d-block">'.__('Prefix for admin username').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('Selected option will be set as prefix for admin username on the script install form<br/> Please do not use a hyphen - as it will be used as a seperator').'</span>
			<select id="admin_prefix" name="admin_prefix" onchange="show_ud(this);" class="form-control">
				<option value="" '.((isset($_POST['admin_prefix']) && $_POST['admin_prefix'] == "") ? 'selected="selected"' : ((!isset($_POST['admin_prefix']) && $globals['admin_prefix'] == "") ? 'selected="selected"' : '')).'>'.__('None').'</option>
				
				<option value="username" '.((isset($_POST['admin_prefix']) && $_POST['admin_prefix'] == "username") ? 'selected="selected"' : ((!isset($_POST['admin_prefix']) && $globals['admin_prefix'] == "username") ? 'selected="selected"' : '')).'>'.__('Username').'</option>
				
				<option value="domain" '.((isset($_POST['admin_prefix']) && $_POST['admin_prefix'] == "domain") ? 'selected="selected"' : ((!isset($_POST['admin_prefix']) && $globals['admin_prefix'] == "domain") ? 'selected="selected"' : '')).'>'.__('Domain').'</option>
				
				<option value="user_defined" '.((isset($_POST['admin_prefix']) && $_POST['admin_prefix'] == "user_defined") ? 'selected="selected"' : ((!isset($_POST['admin_prefix']) && $globals['admin_prefix'] != "username" && $globals['admin_prefix'] != "domain" && $globals['admin_prefix'] != "") ? 'selected="selected"' : '')).'>'.__('Admin Defined').'</option>
				
			</select>
			<input type="text" class="form-control" id="admin_prefix_ud" name="admin_prefix_ud" '.((!empty($_POST['admin_prefix_ud']) && $_POST['admin_prefix'] != "" && $_POST['admin_prefix'] != "username" && $_POST['admin_prefix'] != "domain") ? 'value="'.$_POST['admin_prefix_ud'].'" style=""' : ((!isset($_POST['admin_prefix']) && ($globals['admin_prefix'] != "username" && $globals['admin_prefix'] != "domain" && $globals['admin_prefix'] != "")) ? 'value="'.$globals['admin_prefix'].'" style=""' : 'style="display:none"')).' />
		</div>';

	// At the moment only for H-Sphere we are providing this option
	if($globals['softpanel'] == 'hsphere'){
		echo '<div class="form-group">
			<label for="ephp_bin" class="sai-label d-block">'.__('Enduser PHP binary').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('Define the PHP binary path that will be used by the enduser websites. $0 will use this binary for checking the requirements of a script. If not defined $0 will use the default binary as : ', array(APP)).sphpbin().'</span>
			<input type="text" name="ephp_bin" class="form-control" id="ephp_bin" value="'.aPOSTval('ephp_bin', $globals['ephp_bin']).'" size="30" />				
		</div>';
	}
}

if($globals['softpanel'] == 'ampps'){
	echo '<div class="form-group">
			<label for="adomain_path" class="sai-label d-block">'.__('Default Domain Path').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('While adding domain you can set the default domain path.').'</span>
			<input type="text" name="adomain_path" id="adomain_path" class="form-control" size="30" value="'.aPOSTval('adomain_path', $globals['adomain_path']).'" />
		</div>';
}

if($globals['softpanel'] != 'ampps' && !empty($globals['ampps_enabled']) && !empty($globals['lictype'])){
	echo '<div class="form-group">
			<input type="checkbox" name="no_ampps" '.POSTchecked('no_ampps', @$globals['no_ampps']).' />
			<label class="sai-label">'.__('Disable AMPPS download link').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('This will disable the AMPPS download link in $0 Enduser panel', array(APP)).'</span>
		</div>';
}

if(!defined('SOFTRESELLER')){
	echo '<div class="form-group">
			<input type="checkbox" id="no_strong_mysql_pass" name="no_strong_mysql_pass" '.POSTchecked('no_strong_mysql_pass', @$globals['no_strong_mysql_pass']).' />
			<label class="sai-label" for="no_strong_mysql_pass">'.__("Don't generate strong MySQL database user password").'</label>
			<span class="sai_exp2 d-block mb-1">'.__('This will generate MySQL database user password without special characters').'</span>
		</div>
	
		<div class="form-group">			
			<label for="dbpass_len" class="sai-label d-block">'.__('Length for random generated MySQL database user password').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('Choose the length of random generated database user password. If left blank $0 will use default: 10', array(APP)).'</span>
			<input type="text" id="dbpass_len" name="dbpass_len" class="form-control" value="'.aPOSTval('dbpass_len', @$globals['dbpass_len']).'" onblur="isNumber(this)"/>
		</div>
	
		<div class="form-group">
			<input type="checkbox" name="pre_download_all" '.POSTchecked('pre_download_all', @$globals['pre_download_all']).' />
			<label class="sai-label">'.__('Enable Pre Download for all scripts').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('This will enable pre download for all scripts including new scripts added').'</span>			
		</div>

		<div class="form-group">
			<input type="checkbox" id="enc_db_pass" name="enc_db_pass" '.POSTchecked('enc_db_pass', @$globals['enc_db_pass']).' />
			<label class="sai-label" for="enc_db_pass">'.__('Store Database Password in encrypted format').'</label>
			<span class="sai_exp2 d-block mb-1">'.__("If selected, then the Database Password for users' installations will be stored in encrypted format. This will require <b>mcrypt</b> extension.").'</span>			
		</div>

		<div class="form-group">
			<input type="checkbox" id="disable_branches" name="disable_branches" '.POSTchecked('disable_branches', @$globals['disable_branches']).' />	
			<label class="sai-label" for="disable_branches">'.__('Disable Scripts Branches').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('If checked, all the branches of a script will be disabled except the parent one').'</span>
		</div>';

	if(asperapp(1, 0, 0)){ // Only for Softaculous
	echo '<div class="form-group">
			<label class="sai-label d-block" for="default_landing">'.__('Default page for Enduser Panel').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('This will be the default page for $0 Enduser Panel', array(APP)).'</span>
			<select name="default_landing" class="form-control" id="default_landing">
				<option value="" '.(!isset($_POST['default_landing']) && empty($globals['default_landing']) ? 'selected="selected"' : '').'>'.__('Top Scripts (Default)').'</option>
				<option value="wordpress" '.(isset($_POST['default_landing']) && $_POST['default_landing'] == 'wordpress' ? 'selected="selected"' : ($globals['default_landing'] == 'wordpress' ? 'selected="selected"' : '')).'>'.__('WordPress Manager').'</option>
				<option value="installations" '.(isset($_POST['default_landing']) && $_POST['default_landing'] == 'installations' ? 'selected="selected"' : ($globals['default_landing'] == 'installations' ? 'selected="selected"' : '')).'>'.__('All Installations').'</option>
				<option value="outdated_ins" '.(isset($_POST['default_landing']) && $_POST['default_landing'] == 'outdated_ins' ? 'selected="selected"' : ($globals['default_landing'] == 'outdated_ins' ? 'selected="selected"' : '')).'>'.__('Outdated Installations').'</option>
				<option value="all_scripts" '.(isset($_POST['default_landing']) && $_POST['default_landing'] == 'all_scripts' ? 'selected="selected"' : ($globals['default_landing'] == 'all_scripts' ? 'selected="selected"' : '')).'>'.__('All Scripts').'</option>
			</select>
		</div>';
	}

	if(aefer()){
	echo '<div class="form-group">
			<input type="checkbox" id="no_ftp_encrypted" name="no_ftp_encrypted" '.POSTchecked('no_ftp_encrypted', @$globals['no_ftp_encrypted']).' />
			<label class="sai-label" for="no_ftp_encrypted">'.__("Don't encrypt the FTP Password").'</label>
			<span class="sai_exp2 d-block mb-1">'.__('This will store FTP Passwords of Domain in the database without encryption').'</span>
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="no_add_domain" name="no_add_domain" '.POSTchecked('no_add_domain', @$globals['no_add_domain']).' />
			<label class="sai-label" for="no_add_domain">'.__('Disable Adding domains by Endusers').'</label><br />
			<span class="sai_exp2 d-block mb-1">'.__('This will not allow Endusers to add domains').'</span>
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="no_prefill_db" name="no_prefill_db" '.POSTchecked('no_prefill_db', @$globals['no_prefill_db']).' />
			<label class="sai-label" for="no_prefill_db">'.__("Don't Prefill Database details").'</label>
			<span class="sai_exp2 d-block mb-1">'.__("Don't prefill the database details by default.").'</span>
		</div>';
	}

	if(aefer() || ent()){
	echo '<div class="form-group">
			<label for="session_timeout" class="sai-label d-block">'.__('Session Timeout').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('Softaculous Session will remain active for the time specified.<br />Time should be in minutes. Default: 15').'</span>
			<input type="text" id="session_timeout" name="session_timeout" class="form-control" value="'.aPOSTval('session_timeout', @$globals['session_timeout']).'" onblur="isNumber(this)"/>
		</div>
	
		<div class="form-group">
			<input type="checkbox" id="sync_domains" name="sync_domains" '.POSTchecked('sync_domains', @$globals['sync_domains']).' />
			<label class="sai-label" for="sync_domains">'.__('Enable Sync Domain(s)').'</label>
			<span class="sai_exp2 d-block mb-1">'.(aefer() ? __('This will enable the synchronizing of Domain(s) in $0 records with the domain(s) list passed via $PRE_LOGIN in session.php, click <a href="http://www.softaculous.com/docs/Softaculous_Remote#sync-domains" target="_blank">here</a> to for guide', array(APP)) : __('This will enable the synchronizing of Domain(s) in $0 records with the domain(s) list passed via $PRE_LOGIN in session.php, click <a href="http://www.softaculous.com/docs/Softaculous_Enterprise_Integration#sync-domains" target="_blank">here</a> to for guide', array(APP))).'</span>
		</div>';
	}		
		
	echo '<div class="form-group">
			<input type="checkbox" id="no_prefill_pass" name="no_prefill_pass" '.POSTchecked('no_prefill_pass', @$globals['no_prefill_pass']).' />		
			<label class="sai-label" for="no_prefill_pass">'.__("Don't Prefill Password fields").'</label>
			<span class="sai_exp2 d-block mb-1">'.__('While editing an installation or a domain the password will not be prefilled').'</span>
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="disable_sign_on" name="disable_sign_on" '.POSTchecked('disable_sign_on', @$globals['disable_sign_on']).' />	
			<label class="sai-label" for="disable_sign_on">'.__('Disable Auto Login').'</label>
			<span class="sai_exp2 d-block mb-1">'.__("Select this option to disable auto login to script's admin panel from $0", array(APP)).'</span>
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="use_eu_username" name="use_eu_username" '.POSTchecked('use_eu_username', @$globals['use_eu_username']).' />	
			<label class="sai-label" for="use_eu_username">'.__('Prefill Control Panel Username as Admin Username').'</label>
			<span class="sai_exp2 d-block mb-1">'.__("If set, the script installation's Admin Username on the script install form will be prefilled as Control Panel Username").'</span>
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="use_eu_email" name="use_eu_email" '.POSTchecked('use_eu_email', @$globals['use_eu_email']).' />
			<label class="sai-label" for="use_eu_email">'.__('Prefill Enduser Email as Admin Email').'</label>
			<span class="sai_exp2 d-block mb-1">'.__("If set, the script installation's Admin Email on the script install form will be prefilled as the Email set in Enduser Email Settings").'</span>
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="off_available_space" name="off_available_space" '.POSTchecked('off_available_space', @$globals['off_available_space']).' />
			<label class="sai-label" for="off_available_space">'.__("Don't display available space").'</label>
			<span class="sai_exp2 d-block mb-1">'.__("If checked, Available Space will not be displayed on the script's Overview page").'</span>
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="off_checkhttps" name="off_checkhttps" '.POSTchecked('off_checkhttps', @$globals['off_checkhttps']).' />	
			<label class="sai-label" for="off_checkhttps">'.__('Disable SSL certificate check on script install form').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('This will disable the SSL certificate check for domains when a user selects to install a script on https protocol and will not see any error if SSL certificate is not installed').'</span>
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="quick_install_default" name="quick_install_default" '.POSTchecked('quick_install_default', @$globals['quick_install_default']).' />	
			<label class="sai-label" for="quick_install_default">'.__('Set Quick Install as the default install option').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('If selected, the default install form will show minimal options (only required fields)').'</span>
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="off_custom_install" name="off_custom_install" '.POSTchecked('off_custom_install', @$globals['off_custom_install']).' />	
			<label class="sai-label" for="off_custom_install">'.__('Set Quick Install as the default and disable Custom Install').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('If selected, the install form will show minimal options (only required fields) and custom install form will be disabled').'</span>
		</div>';
		
	if(!aefer() && !ent()){
	echo'<div class="form-group">
			<input type="checkbox" id="sync_ins_list" name="sync_ins_list" '.POSTchecked('sync_ins_list', @$globals['sync_ins_list']).' />		
			<label class="sai-label" for="sync_ins_list">'.__('Sync installations list with $0 Records', array(APP)).'</label>
			<span class="sai_exp2 d-block mb-1">'.__("Check if the installation directory exists in the user's web directory and remove the installation(s) from $0 records for which directory does not exist", array(APP)).'</span>
		</div>
	
		<div class="form-group">
			<input type="checkbox" id="sync_ins_real_ver" name="sync_ins_real_ver" '.POSTchecked('sync_ins_real_ver', @$globals['sync_ins_real_ver']).' />	
			<label class="sai-label" for="sync_ins_real_ver">'.__('Detect and update actual version of installations').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('Detect if the user has manually updated their installation and update the version in $0 records in case of version mismatch', array(APP)).'</span>
		</div>
		
		<div class="form-group">
			<label for="max_staging" class="sai-label d-block">'.__('Maximum Staging installations per user limit').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('This will limit the maximum number of staging installations a user can create. Default : Unlimited').'</span>
			<input type="text" name="max_staging" id="max_staging" class="form-control" size="30" value="'.aPOSTval('max_staging', $globals['max_staging']).'" />			
		</div>

		<div class="form-group">
			<label for="screenshot_frequency" class="sai-label">'.__('Installation Screenshot Frequency').'</label>
			<span class="sai_exp2 d-block mb-1">'.__("Set the frequency (in hours) for updating screenshots for enduser's installations. Default value : 1 hour").'</span>
			<div class="input-group position-relative w-75">
				<input type="number" id="screenshot_frequency" class="form-control" aria-describedby="screenshot_frequency" name="screenshot_frequency" value="'.aPOSTval('screenshot_frequency', @$globals['screenshot_frequency']).'" onblur="isNumber(this)"/ >
				<label class="input-group-addon sai-label after-text" id="screenshot_frequency">'.__('Hour(s)').'</label>
			</div>
		</div>';
	}
}

echo '<p><input type="submit" class="flat-butt " name="editsettings" value="'.__('Edit Settings').'"/></p>
	</div>
</div><br />';

if(!defined('SOFTRESELLER')){
echo '<div class="sai-card p-3">
<div class="sai_main_head mb-2">
	<h2 class="sai-heading mb-2">'.__('Backup Settings').'</h2>
	<hr class="sai_main_head_hr"/>
</div>
	<div class="sai_form">
		<div class="form-group">
			<label class="sai-label d-block">'.__('Disable Automated Backups for Enduser').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('If checked then the option for automated backups will be disabled for endusers.').'</span>		
			
			<div class="row">
				<div class="col-12">
					<p class="sai-details">
						<input type="checkbox" id="disable_auto_backup" name="disable_auto_backup" '.POSTchecked('disable_auto_backup', @$globals['disable_auto_backup']).' />
						<span class="sai-label ml-1"><label class="sai-label" for="disable_auto_backup">'.__('All').'</label></span>
					</p>	
					<p class="sai-details">
						<input type="checkbox" id="disable_auto_backup_daily" name="disable_auto_backup_daily" '.POSTchecked('disable_auto_backup_daily', @$globals['disable_auto_backup_daily']).' />
						<span class="sai-label ml-1"><label class="sai-label" for="disable_auto_backup_daily">'.__('Disable Daily Auto backups').'</label></span>
					</p>
					<p class="sai-details">
						<input type="checkbox" id="disable_auto_backup_weekly" name="disable_auto_backup_weekly" '.POSTchecked('disable_auto_backup_weekly', @$globals['disable_auto_backup_weekly']).' />
						<span class="sai-label ml-1"><label class="sai-label" for="disable_auto_backup_weekly">'.__('Disable Weekly Auto backups').'</label></span>
					</p>
					<p class="sai-details">
						<input type="checkbox" id="disable_auto_backup_monthly" name="disable_auto_backup_monthly" '.POSTchecked('disable_auto_backup_monthly', @$globals['disable_auto_backup_monthly']).' />
						<span class="sai-label ml-1"><label class="sai-label" for="disable_auto_backup_monthly">'.__('Disable Monthly Auto backups').'</label></span>
					</p>
					<p class="sai-details">
						<input type="checkbox" id="disable_auto_backup_custom" name="disable_auto_backup_custom" '.POSTchecked('disable_auto_backup_custom', @$globals['disable_auto_backup_custom']).' />
						<span class="sai-label ml-1"><label class="sai-label" for="disable_auto_backup_custom">'.__('Disable Custom time for Auto backups').'</label></span>
					</p>
				</div>
			</div>
		</div>';

	if(!aefer() && !ent()){	
	echo'<div class="form-group">
			<label class="sai-label d-block" for="auto_backup">'.__('Default auto backup frequency').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('Choose the default auto backup frequency. The chosen value will be pre-selected for endusers').'</span>
		
			<select name="auto_backup" class="form-control" id="auto_backup">
				<option value="0" '.POSTselect('auto_backup', '0', 1).'>'.__("Don't backup").'</option>
				<option value="daily" '.POSTselect('auto_backup', 'daily', ($globals['auto_backup'] == 'daily' ? 1 : '')).'>'.__('Once a day').'</option>
				<option value="weekly" '.POSTselect('auto_backup', 'weekly', ($globals['auto_backup'] == 'weekly' ? 1 : '')).'>'.__('Once a week').'</option>
				<option value="monthly" '.POSTselect('auto_backup', 'monthly', ($globals['auto_backup'] == 'monthly' ? 1 : '')).'>'.__('Once a month').'</option>
			</select>
		</div>
		
		<div class="form-group">
			<label class="sai-label d-block" for="auto_backup_rotation">'.__('Default auto backup rotation').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('Choose the default auto backup rotation. The chosen value will be pre-selected for endusers').'</span>
			<select name="auto_backup_rotation" id="auto_backup_rotation" class="form-control">';
				for($i=0; $i<=10; $i++){
					echo '<option value="'.$i.'" '.(empty($_POST['auto_backup_rotation']) && $globals['auto_backup_rotation'] == $i ? 'selected="selected"' : (trim($_POST['auto_backup_rotation']) == $i ? 'selected="selected"' : '') ).'>'.(empty($i) ? __('Default') : ($i == -1 ? __('Unlimited') : $i)).'</option>';        
				}
				echo '<option value="-1" '.(empty($_POST['auto_backup_rotation']) && $globals['auto_backup_rotation'] == -1 ? 'selected="selected"' : (trim($_POST['auto_backup_rotation']) == -1 ? 'selected="selected"' : '') ).'>'.__('Unlimited').'</option>';
			echo '</select>
		</div>';
	}
	echo'<div class="form-group">
			<label class="sai-label d-block" for"auto_backup_limit">'.__('Auto backup rotation limit').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('Choose the maximum limit for auto backups rotation for the endusers').'</span>
			<select name="auto_backup_limit" id="auto_backup_limit" class="form-control">';    
				for($i=0; $i<=10; $i++){
					echo '<option value="'.$i.'" '.(empty($_POST['auto_backup_limit']) && $globals['auto_backup_limit'] == $i ? 'selected="selected"' : (trim($_POST['auto_backup_limit']) == $i ? 'selected="selected"' : '') ).'>'.(empty($i) ? __('Unlimited') : $i).'</option>';        
				}	
			echo '</select>
		</div>
	
		<div class="form-group">		
			<label class="sai-label d-block" for="max_backups">'.__('Maximum backups per user (Local & Remote)').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('This will limit the maximum number of backups a user can take on local and remote locations.').'</span>			
			<select name="max_backups" id="max_backups" class="form-control">';
				for($i=0; $i<=10; $i++){
					echo '<option value="'.$i.'" '.(empty($_POST['max_backups']) && $globals['max_backups'] == $i ? 'selected="selected"' : (trim($_POST['max_backups']) == $i ? 'selected="selected"' : '') ).'>'.(empty($i) ? __('Unlimited') : $i).'</option>';        
				}	
			echo '</select>
		</div>
		
		<div class="form-group">
			<label class="sai-label d-block" for="max_backups_local">'.__('Maximum backups per user (Local)').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('This will limit the maximum number of backups a user can take on local server (Remote locations not included)').'</span>
			<select name="max_backups_local" id="max_backups_local" class="form-control">';
			for($i=0; $i<=10; $i++){
					echo '<option value="'.$i.'" '.(empty($_POST['max_backups_local']) && $globals['max_backups_local'] == $i ? 'selected="selected"' : (trim($_POST['max_backups_local']) == $i ? 'selected="selected"' : '') ).'>'.(empty($i) ? __('Unlimited') : $i).'</option>';        
				}	
			echo '</select>
		</div>
		
		<div class="form-group">		
			<label class="sai-label d-block" for="max_insid_backups">'.__('Maximum backups per installation (Local & Remote)').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('This will limit the maximum number of backups a user can perform per installation on local and remote locations.').'</span>			
			<select name="max_insid_backups" id="max_insid_backups" class="form-control">';
				for($i=0; $i<=10; $i++){
					echo '<option value="'.$i.'" '.(empty($_POST['max_insid_backups']) && $globals['max_insid_backups'] == $i ? 'selected="selected"' : (trim($_POST['max_insid_backups']) == $i ? 'selected="selected"' : '') ).'>'.(empty($i) ? __('Unlimited') : $i).'</option>';        
				}	
			echo '</select>
		</div>
		
		<div class="form-group">
			<label class="sai-label d-block" for="max_insid_backups_local">'.__('Maximum backups per installation (Local)').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('This will limit the maximum number of backups a user can perform per installation on local server (Remote locations not included)').'</span>
			<select name="max_insid_backups_local" id="max_insid_backups_local" class="form-control">';
			for($i=0; $i<=10; $i++){
					echo '<option value="'.$i.'" '.(empty($_POST['max_insid_backups_local']) && $globals['max_insid_backups_local'] == $i ? 'selected="selected"' : (trim($_POST['max_insid_backups_local']) == $i ? 'selected="selected"' : '') ).'>'.(empty($i) ? __('Unlimited') : $i).'</option>';        
				}	
			echo '</select>
		</div>';

		if(!aefer() && !ent()){
		echo '<div class="form-group">
				<label for="backups_expire" class="sai-label d-block">'.__('Delete Backup Frequency (Local)').'</label>
				<span class="sai_exp2 d-block mb-1">'.__("If you would like to delete your users' backups created on local server after certain days since backup creation. By default the backups are never deleted.").'</span>
				<div class="input-group position-relative w-75">
					<input type="text" id="backups_expire" class="form-control" aria-describedby="backups_expire" name="backups_expire" value="'.aPOSTval('backups_expire', @$globals['backups_expire']).'" onblur="isNumber(this)"/ >
					<span class="input-group-addon after-text sai-label" id="backups_expire">'.__('Day(s)').'</span>
				</div>
			</div>';
		}
		
	echo '<div class="form-group">
			<input type="checkbox" id="disable_backup_restore" name="disable_backup_restore" size="30" '.POSTchecked('disable_backup_restore', @$globals['disable_backup_restore']).' />			
			<label class="sai-label" for="disable_backup_restore">'.__('Disable Backup/Restore Function for Endusers').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('This will turn off the backup and restore function for endusers.').'</span>
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="disable_backup_upgrade" name="disable_backup_upgrade" '.POSTchecked('disable_backup_upgrade', @$globals['disable_backup_upgrade']).' />
			<label class="sai-label" for="disable_backup_upgrade">'.__('Disable backup option during upgrades').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('This will disable the backup option on the upgrade installation page for endusers').'</span>
		</div>
		
		<div class="form-group">
			<label for="set_backup_dir" class="sai-label">'.__('Set Backup Directory').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('Choose the path to store enduser(s) installation backups. <br /> This will be absolute path i.e. if you enter /backups then the backups will be created at /backups/USERNAME directory on your server. This directory should exist and should be writable for all users.').'</span>
			<input type="text" name="set_backup_dir" id="set_backup_dir" class="form-control" size="20" value="'.aPOSTval('set_backup_dir', @$globals['set_backup_dir']).'" />			
		</div>
		
		<div class="form-group">
			<input type="checkbox" name="upgrade_backup_on" id="upgrade_backup_on" '.POSTchecked('upgrade_backup_on', @$globals['upgrade_backup_on']).' />	
			<label for="upgrade_backup_on" class="sai-label">'.__('Set Backup checkbox pre-selected on Upgrade').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('If selected, the Create Backup checkbox on the script upgrade page will be selected by default').'</span>
		</div>
		
		<div class="form-group">
			<label class="sai-label">'.__('Disable Backup Locations for Enduser').'</label><br />
			<span class="sai_exp2 d-block mb-1">'.__('Select the backup locations you would like to disable for endusers').'</span>
			<div class="row">
				<div class="col-6">
					<p class="sai-details">
						<input type="checkbox" id="disable_local_backup" name="disable_local_backup" '.POSTchecked('disable_local_backup', @$globals['disable_local_backup']).' />
						<span class="sai-label ml-1"><label class="sai-label" for="disable_local_backup">'.__('Local Backups').'</label></span>
					</p>
					<p class="sai-details">
						<input type="checkbox" id="disable_backup_ftp" name="disable_backup_ftp" '.POSTchecked('disable_backup_ftp', @$globals['disable_backup_ftp']).' />
						<span class="sai-label ml-1"><label class="sai-label" for="disable_backup_ftp">'.__('FTP').'</label></span>
					</p>
					<p class="sai-details">
						<input type="checkbox" id="disable_backup_softftpes" name="disable_backup_softftpes" '.POSTchecked('disable_backup_softftpes', @$globals['disable_backup_softftpes']).' />
						<span class="sai-label ml-1"><label class="sai-label" for="disable_backup_softftpes">'.__('FTPS').'</label></span>
					</p>
					<p class="sai-details">
						<input type="checkbox" id="disable_backup_softsftp" name="disable_backup_softsftp" '.POSTchecked('disable_backup_softsftp', @$globals['disable_backup_softsftp']).' />
						<span class="sai-label ml-1"><label class="sai-label" for="disable_backup_softsftp">'.__('SFTP').'</label></span>
					</p>
					<p class="sai-details">
						<input type="checkbox" id="disable_backup_aws" name="disable_backup_aws" '.POSTchecked('disable_backup_aws', @$globals['disable_backup_aws']).' />
						<span class="sai-label ml-1"><label class="sai-label" for="disable_backup_aws">'.__('Amazon S3').'</label></span>
					</p>
				</div>
				<div class="col-6">
					<p class="sai-details">
						<input type="checkbox" id="off_rbackup" name="off_rbackup" '.POSTchecked('off_rbackup', @$globals['off_rbackup']).' />
						<span class="sai-label ml-1"><label class="sai-label" for="off_rbackup">'.__('All Remote Locations').'</label></span>
					</p>
					<p class="sai-details">
						<input type="checkbox" id="disable_backup_dropbox" name="disable_backup_dropbox" '.POSTchecked('disable_backup_dropbox', @$globals['disable_backup_dropbox']).' />
						<span class="sai-label ml-1"><label class="sai-label" for="disable_backup_dropbox">'.__('Dropbox').'</label></span>
					</p>
					<p class="sai-details">
						<input type="checkbox" id="disable_backup_gdrive" name="disable_backup_gdrive" '.POSTchecked('disable_backup_gdrive', @$globals['disable_backup_gdrive']).' />
						<span class="sai-label ml-1"><label class="sai-label" for="disable_backup_gdrive">'.__('Google Drive').'</label></span>
					</p>
					<p class="sai-details">
						<input type="checkbox" id="disable_backup_webdav" name="disable_backup_webdav" '.POSTchecked('disable_backup_webdav', @$globals['disable_backup_webdav']).' />
						<span class="sai-label ml-1"><label class="sai-label" for="disable_backup_webdav">'.__('WebDAV').'</label></span>
					</p>
					<p class="sai-details">
						<input type="checkbox" id="disable_backup_onedrive" name="disable_backup_onedrive" '.POSTchecked('disable_backup_onedrive', @$globals['disable_backup_onedrive']).' />
						<span class="sai-label ml-1"><label class="sai-label" for="disable_backup_onedrive">'.__('Microsoft OneDrive').'</label></span>
					</p>
				</div>
			</div>
		</div>
		
		<div class="form-group">
			<input type="checkbox" name="off_backup_au" id="off_backup_au" '.POSTchecked('off_backup_au', @$globals['off_backup_au']).' />	
			<label for="off_backup_au" class="sai-label">'.__('Disable Backups before Auto Upgrade').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('If selected, backups will not be performed before upgrading installations or plugins and themes. Note: Make sure you have backups which you can use in case the upgrade fails.').'</span>
		</div><br />
		
		<div class="form-group">
				<input type="checkbox" name="off_push_to_live_backup" id="off_push_to_live_backup" '.POSTchecked('off_push_to_live_backup', @$globals['off_push_to_live_backup']).' />	
				<label for="off_push_to_live_backup" class="sai-label">'.__('Disable Backups before Push to Live').'</label>
				<span class="sai_exp2 d-block mb-1">'.__('If selected, backups will not be performed before pushing the staging site to live. Note: Make sure you have backups which you can use in case the Push to Live fails.').'</span>
		</div><br />
		<p><input type="submit" class="flat-butt " name="editsettings" value="'.__('Edit Settings').'"/></p>
	</div>
</div><br />';
}

echo '<div class="sai-card p-3">
	<div class="sai_main_head mb-2">
		<h2 class="sai-heading mb-2">'.__('Email Settings').'</h2>
		<hr class="sai_main_head_hr"/>
	</div>
	<div class="sai_form">
		<div class="form-group">
			<input type="checkbox" name="off_email_link" '.POSTchecked('off_email_link', $globals['off_email_link']).' />	
			<label class="sai-label">'.__('Turn off all Emails sent to endusers').'</label>
			<span class="sai_exp2 d-block mb-1">'.__('This will turn off the Email Link for the endusers and ALSO disable emails that are sent during installation, removal, etc.').'</span>			
		</div>';

if(!defined('SOFTRESELLER')){
echo '<div class="form-group">
		<input type="checkbox" id="off_remove_mail" name="off_remove_mail" '.POSTchecked('off_remove_mail', $globals['off_remove_mail']).' />
		<label class="sai-label" for="off_remove_mail">'.__('Turn off Remove Installation emails').'</label>
		<span class="sai_exp2 d-block mb-1">'.__('This will disable the email sent to endusers during removal of installation(s).').'</span>
	</div>

	<div class="form-group">
		<input type="checkbox" id="off_install_mail" name="off_install_mail" '.POSTchecked('off_install_mail', $globals['off_install_mail']).' />		
		<label class="sai-label" for="off_install_mail">'.__('Turn off New Installation emails').'</label>
		<span class="sai_exp2 d-block mb-1">'.__('This will disable the email sent to endusers during installation of an application.').'</span>
	</div>
	
	<div class="form-group">	
		<input type="checkbox" id="off_edit_mail" name="off_edit_mail" '.POSTchecked('off_edit_mail', $globals['off_edit_mail']).' />	
		<label class="sai-label" for="off_edit_mail">'.__('Turn off Edit Installation emails').'</label>
		<span class="sai_exp2 d-block mb-1">'.__('This will disable the email sent to endusers when installation details are edited.').'</span>
	</div>
	
	<div class="form-group">
		<input type="checkbox" id="off_clone_mail" name="off_clone_mail" '.POSTchecked('off_clone_mail', $globals['off_clone_mail']).' />	
		<label class="sai-label" for="off_clone_mail">'.__('Turn off Clone Installation emails').'</label>
		<span class="sai_exp2 d-block mb-1">'.__('This will disable the email sent to endusers when an installation is cloned.').'</span>
	</div>
	
	<div class="form-group">
		<input type="checkbox" id="off_staging_mail" name="off_staging_mail" '.POSTchecked('off_staging_mail', $globals['off_staging_mail']).' />	
		<label class="sai-label" for="off_staging_mail">'.__('Turn off Staging Installation emails').'</label>
		<span class="sai_exp2 d-block mb-1">'.__('This will disable the email sent to endusers when staging an installation').'</span>
	</div>
	
	<div class="form-group">
		<input type="checkbox" id="eu_email_off" name="eu_email_off" '.POSTchecked('eu_email_off', @$globals['eu_email_off']).' />
		<label class="sai-label" for="eu_email_off">'.__('Disable End User Update E-Mails').'</label>
		<span class="sai_exp2 d-block mb-1">'.__('If checked no emails will be sent to the enduser when there is a Update available.').'</span>
	</div>
	
	<div class="form-group">
		<input type="checkbox" id="off_backup_mail" name="off_backup_mail" '.POSTchecked('off_backup_mail', $globals['off_backup_mail']).' />
		<label class="sai-label" for="off_backup_mail">'.__('Turn off Backup Installation emails').'</label>
		<span class="sai_exp2 d-block mb-1">'.__('This will disable the email sent to endusers during backup of installation(s).').'</span>		
	</div>
	
	<div class="form-group">
		<input type="checkbox" id="off_restore_mail" name="off_restore_mail" '.POSTchecked('off_restore_mail', $globals['off_restore_mail']).' />
		<label class="sai-label" for="off_restore_mail">'.__('Turn off Restore Installation emails').'</label>
		<span class="sai_exp2 d-block mb-1">'.__('This will disable the email sent to endusers when an installation is restored.').'</span>
	</div>
	
	<div class="form-group">
		<input type="checkbox" id="off_template_mail" name="off_template_mail" '.POSTchecked('off_template_mail', $globals['off_template_mail']).' />
		<label class="sai-label" for="off_template_mail">'.__('Turn off Create Template emails').'</label>
		<span class="sai_exp2 d-block mb-1">'.__('This will disable the email sent to endusers during creating a template of installation(s).').'</span>		
	</div>
	
	<div class="form-group">
		<input type="checkbox" id="off_restore_template_mail" name="off_restore_template_mail" '.POSTchecked('off_restore_template_mail', $globals['off_restore_template_mail']).' />
		<label class="sai-label" for="off_restore_template_mail">'.__('Turn off Restore Template emails').'</label>
		<span class="sai_exp2 d-block mb-1">'.__('This will disable the email sent to endusers during restoring a template.').'</span>
	</div>
	
	<div class="form-group">
		<input type="checkbox" id="off_import_mail" name="off_import_mail" '.POSTchecked('off_import_mail', $globals['off_import_mail']).' />
		<label class="sai-label" for="off_import_mail">'.__('Turn off Import Installation emails').'</label>
		<span class="sai_exp2 d-block mb-1">'.__('This will disable the email sent to endusers when an installation is imported.').'</span>
	</div>';
}

echo '<div class="form-group">
	<input type="checkbox" id="email_password" name="email_password" '.POSTchecked('email_password', $globals['email_password']).' />			
	<label class="sai-label" for="email_password">'.__('Email password in plain text').'</label><br />
	<span class="sai_exp2 d-block mb-1">'.__('If checked, the passwords will be sent in plain-text to the users via email for install, clone, etc.').'</span>
</div>
	
	<div class="form-group">
		<label class="sai-label">'.__('Default Email Settings for endusers').'</label><br />
		<span class="sai_exp2 d-block mb-2">'.__('Choose the default email settings for the endusers. Users can change the settings as per their preference.').'</span>
		<div class="row mt-1">
			<div class="col-12 col-lg-6">
				<span class="d-block">
					<input type="checkbox" id="eu_off_default_install_notify" name="eu_off_default_install_notify" '.(isset($_REQUEST['eu_off_default_install_notify']) || empty($globals['eu_off_default_install_notify']) ? 'checked="checked"' : '').'/>
					<label class="sai-label" for="eu_off_default_install_notify">'.__('Installation Emails').'</label>
				</span>
				<span class="d-block">
					<input type="checkbox" id="eu_off_default_remove_notify" name="eu_off_default_remove_notify" '.(isset($_REQUEST['eu_off_default_remove_notify']) || empty($globals['eu_off_default_remove_notify']) ? 'checked="checked"' : '').' />
					<label class="sai-label" for="eu_off_default_remove_notify"> '.__('Remove Installation Emails').'</label>
				</span>
				<span class="d-block">
					<input type="checkbox" id="eu_off_default_edit_notify" name="eu_off_default_edit_notify" '.(isset($_REQUEST['eu_off_default_edit_notify']) || empty($globals['eu_off_default_edit_notify']) ? 'checked="checked"' : '').' />
					<label class="sai-label" for="eu_off_default_edit_notify">'.__('Edit Installation Emails').'</label>
				</span>
				<span class="d-block">
					<input type="checkbox" id="eu_off_default_backup_notify" name="eu_off_default_backup_notify" '.(isset($_REQUEST['eu_off_default_backup_notify']) || empty($globals['eu_off_default_backup_notify']) ? 'checked="checked"' : '').' />
					<label class="sai-label" for="eu_off_default_backup_notify">'.__('Backup Emails').'</label>
				</span>
				<span class="d-block">
					<input type="checkbox" id="eu_off_default_restore_notify" name="eu_off_default_restore_notify" '.(isset($_REQUEST['eu_off_default_restore_notify']) || empty($globals['eu_off_default_restore_notify']) ? 'checked="checked"' : '').' />
					<label class="sai-label" for="eu_off_default_restore_notify">'.__('Restore Emails').'</label>
				</span>
				<span class="d-block">
					<input type="checkbox" id="eu_off_default_import_notify" name="eu_off_default_import_notify" '.(isset($_REQUEST['eu_off_default_import_notify']) || empty($globals['eu_off_default_import_notify']) ? 'checked="checked"' : '').' />
					<label class="sai-label" for="eu_off_default_import_notify">'.__('Import Emails').'</label>
				</span>
			</div>
			<div class="col-12 col-lg-6">
				<span class="d-block">
					<input type="checkbox" id="eu_off_default_clone_notify" name="eu_off_default_clone_notify" '.(isset($_REQUEST['eu_off_default_clone_notify']) || empty($globals['eu_off_default_clone_notify']) ? 'checked="checked"' : '').' />
					<label class="sai-label" for="eu_off_default_clone_notify">'.__('Clone Emails').'</label>
				</span>
				<span class="d-block">
					<input type="checkbox" id="eu_off_default_staging_notify" name="eu_off_default_staging_notify" '.(isset($_REQUEST['eu_off_default_staging_notify']) || empty($globals['eu_off_default_staging_notify']) ? 'checked="checked"' : '').' />
					<label class="sai-label" for="eu_off_default_staging_notify"> '.__('Staging Emails').'</label>
				</span>
				<span class="d-block">
					<input type="checkbox" id="eu_off_default_template_notify" name="eu_off_default_template_notify" '.(isset($_REQUEST['eu_off_default_template_notify']) || empty($globals['eu_off_default_template_notify']) ? 'checked="checked"' : '').' />
					<label class="sai-label" for="eu_off_default_template_notify">'.__('Create Template Emails').'</label>
				</span>
				<span class="d-block">
					<input type="checkbox" id="eu_off_default_restore_template_notify" name="eu_off_default_restore_template_notify" '.(isset($_REQUEST['eu_off_default_restore_template_notify']) || empty($globals['eu_off_default_restore_template_notify']) ? 'checked="checked"' : '').' />
					<label class="sai-label" for="eu_off_default_restore_template_notify">'.__('Restore Template Emails').'</label>
				</span>
				<span class="d-block">
					<input type="checkbox" id="eu_off_default_update_notify" name="eu_off_default_update_notify" '.(isset($_REQUEST['eu_off_default_update_notify']) || empty($globals['eu_off_default_update_notify']) ? 'checked="checked"' : '').' />
					<label class="sai-label" for="eu_off_default_update_notify">'.__('Updates Notifications Emails').'</label>
				</span>
				<span class="d-block">
					<input type="checkbox" id="eu_default_plainpass_notify" name="eu_default_plainpass_notify" '.POSTchecked('eu_default_plainpass_notify', @$globals['eu_default_plainpass_notify']).' />
					<label class="sai-label" for="eu_default_plainpass_notify">'.__('Send passwords in plain text').'</label>
				</span>
			</div>
		</div>		
	</div><br />

	<p><input type="submit" class="flat-butt " name="editsettings" value="'.__('Edit Settings').'"/></p>
	</div>
</div><br />
<div class="sai-card p-3">
	<div class="sai_main_head mb-2">
		<h2 class="sai-heading mb-2">'.__('Disable Features for End users').'</h2>
		<hr class="sai_main_head_hr"/>
	</div>
	<div class="sai_form">
	
		<div class="form-group">
			<input type="checkbox" onclick="disable_softaculous_modal();" id="disable_softaculous_pro_plugin" name="disable_softaculous_pro_plugin" '.POSTchecked('disable_softaculous_pro_plugin', @$globals['disable_softaculous_pro_plugin']).' />	
			<label class="sai-label" for="disable_softaculous_pro_plugin">'.__('Disable SoftWP / Softaculous Pro Plugin').'</label>
			<span class="sai_exp2 d-block mb-2">'.__('This will disable installing SoftWP plugin while installing WordPress').'</span>
		</div>
		
		<div class="form-group">
		<label for="wp_fp_pref" class="sai-label d-block">'.__('Softaculous Featured Plugins').'</label>
		<span class="sai_exp2 mb-1 d-block">'.__('Choose the default state of Featured Plugins').'</span>
			<select name="wp_fp_pref" id="wp_fp_pref" class="form-control">
				<option value="0" '.POSTselect('wp_fp_pref', 0, (empty($globals['wp_fp_pref']) ? '1' : '0')).'>'.__('Softaculous Recommended (Default)').'</option>
				<option value="1" '.POSTselect('wp_fp_pref', 1, ($globals['wp_fp_pref'] == '1' ? '1' : '0')).'>'.__('Unchecked').'</option>
				<option value="2" '.POSTselect('wp_fp_pref', 2, ($globals['wp_fp_pref'] == '2' ? '1' : '0')).'>'.__('Hide').'</option>
			</select>
		</div>
		<div class="form-group">
			<input type="checkbox" id="wp_fp_modal" name="wp_fp_modal" '.POSTchecked('wp_fp_modal', @$globals['wp_fp_modal']).' />	
			<label class="sai-label" for="wp_fp_modal">'.__('Disable Featured Plugins Modal').'</label>
			<span class="sai_exp2 d-block mb-2">'.__('This will turn off WordPress Featured plugins modal in enduser panel').'</span>
		</div>';
		
		if(!defined('SOFTRESELLER')){
            
			echo '
			<div class="form-group">
				<input type="checkbox" id="disable_wordpress_manager" name="disable_wordpress_manager" '.POSTchecked('disable_wordpress_manager', @$globals['disable_wordpress_manager']).' />	
				<label class="sai-label" for="disable_wordpress_manager">'.__('Disable WordPress Manager').'</label>
				<span class="sai_exp2 d-block mb-2">'.__('This will disable the WordPress manager feature for endusers').'</span>
			</div>';
		
			if($globals['softpanel'] == 'cpanel'){
				echo
				'<div class="form-group">
					<input type="checkbox" id="disable_wp_icon_jupiter" name="disable_wp_icon_jupiter" '.POSTchecked('disable_wp_icon_jupiter', @$globals['disable_wp_icon_jupiter']).' />	
					<label class="sai-label" for="disable_wp_icon_jupiter">'.__('Disable WordPress Manager icon in cPanel jupiter theme').'</label>
					<span class="sai_exp2 d-block mb-2">'.__('This will disable the WordPress manager icon in the left menu in cPanel jupiter theme').'</span>
				</div>';
			}
			
			echo 
			'<div class="form-group">
				<input type="checkbox" id="disable_security_measures" name="disable_security_measures"'.POSTchecked('disable_security_measures', @$globals['disable_security_measures']).'/>	
				<label class="sai-label" for="disable_security_measures">'.__('Disable Security Measures in WordPress Manager').'</label>
				<span class="sai_exp2 d-block mb-2">'.__('This will disable the Security Measures feature for endusers in Wordpress Manager').'</span>
			</div>';
			
		}
		
		echo '
		<div class="form-group">
			<input type="checkbox" id="eu_news_off" name="eu_news_off"'.POSTchecked('eu_news_off', @$globals['eu_news_off']).'/>	
			<label class="sai-label" for="eu_news_off">'.__('Disable End User News').'</label>
			<span class="sai_exp2 d-block mb-2">'.__('If checked this will disable the enduser news of various scripts. This news is for users. It gives latest development news on various scripts, their updates etc.').'</span>
		</div>

		<div class="form-group">
			<input type="checkbox" id="off_demo_link" name="off_demo_link" '.POSTchecked('off_demo_link', @$globals['off_demo_link']).' />	
			<label class="sai-label" for="off_demo_link">'.__('Turn Off Script Demos').'</label>
			<span class="sai_exp2 d-block mb-2">'.__('This will turn off the Demos for the endusers.').'</span>
		</div>
	
		<div class="form-group">
			<input type="checkbox" id="off_screenshot_link" name="off_screenshot_link" '.POSTchecked('off_screenshot_link', @$globals['off_screenshot_link']).' />	
			<label class="sai-label" for="off_screenshot_link">'.__('Turn Off Script Screenshots').'</label>
			<span class="sai_exp2 d-block mb-2">'.__('This will turn off the Screenshots for the endusers.').'</span>
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="off_rating_link" name="off_rating_link" '.POSTchecked('off_rating_link', @$globals['off_rating_link']).' />	
			<label class="sai-label" for="off_rating_link">'.__('Turn Off Script Ratings').'</label>
			<span class="sai_exp2 d-block mb-2">'.__('This will turn off the Ratings for the endusers.').'</span>
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="off_review_link" name="off_review_link" '.POSTchecked('off_review_link', @$globals['off_review_link']).' />
			<label class="sai-label" for="off_review_link">'.__('Turn Off Script Reviews').'</label>
			<span class="sai_exp2 d-block mb-2">'.__('This will turn off the Reviews for the endusers.').'</span>
		</div>';
		
if(!defined('SOFTRESELLER')){
	echo '<div class="form-group">
		<input type="checkbox" id="perl_scripts" name="perl_scripts" '.POSTchecked('perl_scripts', @$globals['perl_scripts']).' />		
		<label class="sai-label" for="perl_scripts">'.__('Disable PERL Scripts').'</label>
		<span class="sai_exp2 d-block mb-2">'.__('This will turn off the PERL Scripts for the endusers').'</span>
	</div>
	<div class="form-group">
		<input type="checkbox" id="nolabels" name="nolabels" size="30" '.POSTchecked('nolabels', $globals['nolabels']).' />
		<label class="sai-label" for="nolabels">'.__('Disable ALL Scripts Category').'</label>
		<span class="sai_exp2 d-block mb-2">'.__('If enabled then no category will be displayed in enduser panel. i.e. PHP, Javascripts, PERL, Classes these all category will be disabled').'</span>
	</div>';
		
	// Classes are only avaialable to Premium License
	if(!empty($globals['lictype'])){
	echo '<div class="form-group">
			<input type="checkbox" id="disable_classes" name="disable_classes" size="30" '.POSTchecked('disable_classes', @$globals['disable_classes']).' />
			<label class="sai-label" for="disable_classes">'.__('Disable PHP Classes').'</label>
			<span class="sai_exp2 d-block mb-2">'.__('This will disable PHP Classes from the enduser.').'</span>
		</div>';
	}
	
	echo '<div class="form-group">
		<input type="checkbox" id="disable_reseller_panel" name="disable_reseller_panel" size="30" '.POSTchecked('disable_reseller_panel', @$globals['disable_reseller_panel']).' />
		<label class="sai-label" for="disable_reseller_panel">'.__('Disable Reseller Panel').'</label>
		<span class="sai_exp2 d-block mb-2">'.__('If enabled then the resellers will not be able to access reseller panel.').'</span>
	</div>
	
	<div class="form-group">
		<input type="checkbox" id="disable_clone" name="disable_clone" '.POSTchecked('disable_clone', @$globals['disable_clone']).' />	
		<label class="sai-label" for="disable_clone">'.__('Disable Clone feature for endusers').'</label>
		<span class="sai_exp2 d-block mb-2">'.__('This will disable the clone installation option for endusers').'</span>
	</div>
	
	<div class="form-group">
		<input type="checkbox" id="disable_import" name="disable_import" '.POSTchecked('disable_import', @$globals['disable_import']).' />
		<label class="sai-label" for="disable_import">'.__('Disable Import feature for endusers').'</label>
		<span class="sai_exp2 d-block mb-2">'.__('This will disable the local import as well as remote import option for endusers').'</span>
	</div>
	
	<div class="form-group">
		<input type="checkbox" id="disable_remote_import" name="disable_remote_import" '.POSTchecked('disable_remote_import', @$globals['disable_remote_import']).' />
		<label class="sai-label" for="disable_remote_import">'.__('Disable Remote Import feature for endusers').'</label>
		<span class="sai_exp2 d-block mb-2">'.__('This will disable the remote import option for endusers').'</span>	
	</div>
		
	<div class="form-group">
		<input type="checkbox" id="disable_manage_sets" name="disable_manage_sets" '.POSTchecked('disable_manage_sets', @$globals['disable_manage_sets']).' />
		<label class="sai-label" for="disable_manage_sets">'.__('Disable WordPress Manage Sets feature for endusers').'</label>
		<span class="sai_exp2 d-block mb-2">'.__('This will disable the WordPress Plugin / Theme Sets feature for endusers. They will be able to install sets created by admin').'</span>
	</div>
	
	<div class="form-group">
		<input type="checkbox" name="off_staging" id="off_staging" '.POSTchecked('off_staging', $globals['off_staging']).' />	
		<label for="off_staging" class="sai-label">'.__('Turn Off Staging').'</label>
		<span class="sai_exp2 d-block mb-2">'.__('This will turn off the Staging feature for endusers').'</span>
	</div>
	
	<div class="form-group">
		<input type="checkbox"  id="off_customize_theme" name="off_customize_theme" '.POSTchecked('off_customize_theme', $globals['off_customize_theme']).' />
		<label class="sai-label" for="off_customize_theme">'.__('Turn off Customize Theme').'</label>
		<span class="sai_exp2 d-block mb-2">'.__('If selected, then Enduser(s) will not be able to access Customise Theme option').'</span>
	</div>

	<div class="form-group">
		<input type="checkbox" id="off_sync_link" name="off_sync_link" '.POSTchecked('off_sync_link', @$globals['off_sync_link']).' />	
		<label class="sai-label" for="off_sync_link">'.__('Turn Off Sync Link').'</label>
		<span class="sai_exp2 d-block mb-2">'.__('This will turn off the Synchronize Link for the endusers.').'</span>		
	</div>

	<div class="form-group">
		<input type="checkbox" id="off_panel_link" name="off_panel_link" '.POSTchecked('off_panel_link', @$globals['off_panel_link']).' />	
		<label class="sai-label" for="off_panel_link">'.__('Turn Off Control Panel Link').'</label>
		<span class="sai_exp2 d-block mb-2">'.__('This will turn off the Control Panel Link in the Dock for the endusers.').'</span>
	</div>
	<div class="form-group">
		<input type="checkbox" id="off_enduser_suggestions" name="off_enduser_suggestions" '.POSTchecked('off_enduser_suggestions', @$globals['off_enduser_suggestions']).' />	
		<label class="sai-label" for="off_enduser_suggestions">'.__('Turn Off Feature Suggestions for Enduser').'</label>
		<span class="sai_exp2 d-block mb-2">'.__('This will turn off Suggestions of Softaculous Features for the endusers').'</span>
	</div>';
}

echo '<p><input type="submit" class="flat-butt " name="editsettings" value="'.__('Edit Settings').'"/></p>
	</div>
</div><br />';

if(!defined('SOFTRESELLER')){
	echo '<div class="sai-card p-3">
	<div class="sai_main_head mb-2">
		<h2 class="sai-heading mb-2">'.__('Auto Upgrade Settings').'</h2>
		<hr class="sai_main_head_hr"/>
	</div>
	<div class="sai_form">
		<div class="form-group">
			<input type="checkbox" id="preselect_autoupgrade_plugins" name="preselect_autoupgrade_plugins" '.POSTchecked('preselect_autoupgrade_plugins', @$globals['preselect_autoupgrade_plugins']).' />
			<label class="sai-label" for="preselect_autoupgrade_plugins">'.__('Pre-select auto upgrade plugins').'</label>
			<span class="sai_exp2 d-block mb-2">'.__('If checked, then auto upgrade plugins option will be pre-checked on the installation page').'</span>				
		</div>		
		<div class="form-group">
			<input type="checkbox" id="preselect_autoupgrade_themes" name="preselect_autoupgrade_themes" '.POSTchecked('preselect_autoupgrade_themes', @$globals['preselect_autoupgrade_themes']).' />
			<label class="sai-label" for="preselect_autoupgrade_themes">'.__('Pre-select auto upgrade themes').'</label>
			<span class="sai_exp2 d-block mb-2">'.__('If checked, then auto upgrade themes option will be pre-checked on the installation page').'</span>
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="force_upgrade_plugins" name="force_upgrade_plugins" '.POSTchecked('force_upgrade_plugins', @$globals['force_upgrade_plugins']).' />		
			<label class="sai-label" for="force_upgrade_plugins">'.__('Force upgrade for Plugins').'</label>
			<span class="sai_exp2 d-block mb-2">'.__('If checked then all the installations plugins will be forcefully auto upgraded.').'</span>
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="force_upgrade_themes" name="force_upgrade_themes" '.POSTchecked('force_upgrade_themes', @$globals['force_upgrade_themes']).' />	
			<label class="sai-label" for="force_upgrade_themes">'.__('Force upgrade for Themes').'</label>
			<span class="sai_exp2 d-block mb-2">'.__('If checked then all the installations themes will be forcefully auto upgraded.').'</span>
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="off_upgrade_plugins" name="off_upgrade_plugins" '.POSTchecked('off_upgrade_plugins', @$globals['off_upgrade_plugins']).' />
			<label class="sai-label" for="off_upgrade_plugins">'.__('Disable auto upgrade plugins for enduser').'</label>
			<span class="sai_exp2 d-block mb-2">'.__("If checked then the option to auto upgrade plugins for user's installations will be disabled for endusers.").'</span>
		</div>
		
		<div class="form-group">
			<input type="checkbox" id="off_upgrade_themes" name="off_upgrade_themes" '.POSTchecked('off_upgrade_themes', @$globals['off_upgrade_themes']).' />
			<label class="sai-label" for="off_upgrade_themes">'.__('Disable auto upgrade themes for enduser').'</label>
			<span class="sai_exp2 d-block mb-2">'.__("If checked then the option to auto upgrade themes for user's installations will be disabled for endusers.").'</span>				
		</div>
		
		<div class="form-group">
			<label class="sai-label">'.__("Prefill Auto Upgrade preference for users' installations").'</label>
			<span class="sai_exp2 d-block mb-2">'.__('Chosen auto upgrade preference, will be selected by default in the enduser panel. Enduser(s) will be able to modify it.').'</span>
			<span class="d-block mb-0">
				<input type="radio" name="enable_auto_upgrade" value="0" '.POSTradio('enable_auto_upgrade', 0, @$globals['enable_auto_upgrade']).' /> 
				<label class="sai-label">'.__('Do not Auto Upgrade (Default)').'</label>
			</span>
			<span class="d-block mb-0">
				<input type="radio" name="enable_auto_upgrade" value="2" '.POSTradio('enable_auto_upgrade', 2, @$globals['enable_auto_upgrade']).' /> 
				<label class="sai-label">'.__('Upgrade to <b>Minor</b> versions only').' </label>
			</span>
			<span class="d-block mb-0">
				<input type="radio" name="enable_auto_upgrade" value="1" '.POSTradio('enable_auto_upgrade', 1, @$globals['enable_auto_upgrade']).' /> 
				<label class="sai-label">'.__('Upgrade to any latest version available (<b>Major</b> as well as <b>Minor</b>)').'</label>
			</span>
		</div>
		
		<div class="form-group">
			<label class="sai-label">'.__("Force Auto Upgrade preference for users' installations").'</label>
			<span class="sai_exp2 d-block mb-2">'.__('Chosen auto upgrade preference, will be selected and disabled in the enduser panel. Enduser(s) will <b>not</b> be able to modify it. (Applicable for new as well as existing installations)').'</span>			
			<span class="d-block mb-0">
				<input type="radio" name="force_auto_upgrade" value="0" '.POSTradio('force_auto_upgrade', 0, @$globals['force_auto_upgrade']).' /> 
				<label class="sai-label">'.__('Do not Auto Upgrade (Default)').'</label>
			</span>
			<span class="d-block mb-0">
				<input type="radio" name="force_auto_upgrade" value="2" '.POSTradio('force_auto_upgrade', 2, @$globals['force_auto_upgrade']).' /> 
				<label class="sai-label">'.__('Upgrade to <b>Minor</b> versions only').'</label>
			</span>
			<span class="d-block mb-0">
				<input type="radio" name="force_auto_upgrade" value="1" '.POSTradio('force_auto_upgrade', 1, @$globals['force_auto_upgrade']).' />
				<label class="sai-label">'.__('Upgrade to any latest version available (<b>Major</b> as well as <b>Minor</b>)').'</label>
			</span>							
		</div>
	
		<div class="form-group">
			<label class="sai-label" for="max_bg_process">'.__('Maximum number of background processes').'</label>
			<span class="sai_exp2 d-block mb-2">'.__('Set the maximum number of processes to be executed simultaneously in background. This will be used for tasks like Auto Upgrade. Default value : 10').'</span>
			<input type="text" id="max_bg_process" name="max_bg_process" class="form-control" size="30" value="'.aPOSTval('max_bg_process', $globals['max_bg_process']).'" />
		</div>
		
		<div class="form-group">
			<label for="au_extra_retry" class="sai-label">'.__('Retry Auto Upgrade Script Plugins and Themes').'</label>
			<span class="sai_exp2 d-block mb-2">'.__('In case the auto upgrade for plugin or theme failed $0 will retry after the given time. Default value : 48 hours', array(APP)).'</span>
			<div class="input-group postion-relative w-75">
				<input type="text" id="au_extra_retry" class="form-control" aria-describedby="au_extra_retry" name="au_extra_retry" value="'.aPOSTval('au_extra_retry', @$globals['au_extra_retry']).'" onblur="isNumber(this)"/ style="width:75%;" >
				<span class="input-group-addon sai-label after-text" id="au_extra_retry">'.__('Hour(s)').'</span>
			</div>
		</div>
		<p><input type="submit" class="flat-butt " name="editsettings" value="'.__('Edit Settings').'"/></p>
	</div>
</div><br />';
}

echo '</div>
</div>
</div>
'.csrf_display().'
</form>

<!-- List Set Items Modal -->
<div class="modal fade" id="disable_softaculous_pro_plugin_modal" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header" style="background:#0069d9;color:#ffffff">
          <h5 class="modal-title">'.__('Disable SoftWP / Softaculous Pro Plugin').'</h5>
          <button type="button" class="close d-inline-block" data-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body" id="list_plugins_themes">
            <div class="modal-body">
				'.__('Are you sure you want to disable Softaculous Pro Plugin ? <br /><br /> You can instead <b>re-brand</b> the plugin with your brand name and logo. <br /><br />The Pro plugin is included in your license cost and it includes features like <b>AI, Onboarding and Assistant</b> for your users. The Softaculous Pro plugin also includes <b>pro version</b> of several plugins like <b><a href="https://loginizer.com" target="_blank">Loginizer</a>, <a href="https://pagelayer.com" target="_blank">Pagelayer</a>, <a href="https://backuply.com" target="_blank">Backuply</a>, <a href="https://speedycache.com" target="_blank">Speedycache</a>, <a href="https://gosmtp.net" target="_blank">GoSMTP</a>, <a href="https://fileorganizer.net" target="_blank">FileOrganizer</a> and more</b> which are included in your license cost. <br /><br />Contact us for more details about Softaculous Pro Plugin at <a href="mailto:sales@softaculous.com">sales@softaculous.com</a>').'
			</div>
        </div>
        <div class="modal-footer">
          <button type="button" class="flat-butt" id="confirmBtn" data-dismiss="modal">'.__('Ok').'</button>
          <button type="button" class="flat-butt" id="cancelBtn" data-dismiss="modal">'.__('Cancel').'</button>
        </div>
      </div>
    </div>
</div>

<script>

function disable_softaculous_modal(){
    
	if($("#disable_softaculous_pro_plugin").is(":checked") === false){
		return true;
	}
	
	$("#disable_softaculous_pro_plugin_modal").modal("show");

	$("#confirmBtn").on("click", function() {
		$("#disable_softaculous_pro_plugin").prop("checked", true);
	});   

	$("#cancelBtn").on("click", function() {
		$("#disable_softaculous_pro_plugin").prop("checked", false);
	});
};

function updateColor(color, id) {
	
	var hexColor = "transparent";
	if(color) {
		hexColor = color.toHexString();
	}
	if(hexColor == "transparent") return;
	
	// Set the hidden value so that we can save the settings
	$("#default_hf_bg").val("1");
	
	// For changing text colors of category heading
	if(id == "default_hf_text"){
		$(".soft_cathead a").css("color", hexColor);
		$(".soft_nav a").css("color", hexColor);
		$(".fa").css("color", hexColor);
		
		// set the hidden value so that it can be saved
		$("#hidden_default_hf_text").val(hexColor);
	}
	
	// For changing text colors of category heading hover color
	if(id == "default_cat_hover"){
		try{
			$(".soft_cathead:hover, .soft_cathead_slide:hover").css("background-color", hexColor);
			//$(".soft_cathead_slide:hover").css("background-color", hexColor);
		
			// set the hidden value so that it can be saved
			$("#hidden_default_cat_hover").val(hexColor);
		}catch(e){
			// do nothing
		}
	}
	
	// For changing text colors of script names
	if(id == "default_scriptname_text"){
		$(".softlinks li a").css("color", hexColor);
		
		// set the hidden value so that it can be saved
		$("#hidden_default_scriptname_text").val(hexColor);
	}
	
	// For changing background color
	if(id == "default_hf_bg"){
		$(".soft_nav").css("background", hexColor);
		
		// set the hidden value so that it can be saved
		$("#hidden_default_hf_bg").val(hexColor);
	}
	
}

var pallete_array = [
		["rgb(0, 0, 0)", "rgb(67, 67, 67)", "rgb(102, 102, 102)", /*"rgb(153, 153, 153)","rgb(183, 183, 183)",*/
		"rgb(204, 204, 204)", "rgb(217, 217, 217)", /*"rgb(239, 239, 239)", "rgb(243, 243, 243)",*/ "rgb(255, 255, 255)"],
		["rgb(152, 0, 0)", "rgb(255, 0, 0)", "rgb(255, 153, 0)", "rgb(255, 255, 0)", "rgb(0, 255, 0)",
		"rgb(0, 255, 255)", "rgb(74, 134, 232)", "rgb(0, 0, 255)", "rgb(153, 0, 255)", "rgb(255, 0, 255)"],
		["rgb(230, 184, 175)", "rgb(244, 204, 204)", "rgb(252, 229, 205)", "rgb(255, 242, 204)", "rgb(217, 234, 211)",
		"rgb(208, 224, 227)", "rgb(201, 218, 248)", "rgb(207, 226, 243)", "rgb(217, 210, 233)", "rgb(234, 209, 220)",
		"rgb(221, 126, 107)", "rgb(234, 153, 153)", "rgb(249, 203, 156)", "rgb(255, 229, 153)", "rgb(182, 215, 168)",
		"rgb(162, 196, 201)", "rgb(164, 194, 244)", "rgb(159, 197, 232)", "rgb(180, 167, 214)", "rgb(213, 166, 189)",
		"rgb(204, 65, 37)", "rgb(224, 102, 102)", "rgb(246, 178, 107)", "rgb(255, 217, 102)", "rgb(147, 196, 125)",
		"rgb(118, 165, 175)", "rgb(109, 158, 235)", "rgb(111, 168, 220)", "rgb(142, 124, 195)", "rgb(194, 123, 160)",
		"rgb(166, 28, 0)", "rgb(204, 0, 0)", "rgb(230, 145, 56)", "rgb(241, 194, 50)", "rgb(106, 168, 79)",
		"rgb(69, 129, 142)", "rgb(60, 120, 216)", "rgb(61, 133, 198)", "rgb(103, 78, 167)", "rgb(166, 77, 121)",
		/*"rgb(133, 32, 12)", "rgb(153, 0, 0)", "rgb(180, 95, 6)", "rgb(191, 144, 0)", "rgb(56, 118, 29)",
		"rgb(19, 79, 92)", "rgb(17, 85, 204)", "rgb(11, 83, 148)", "rgb(53, 28, 117)", "rgb(116, 27, 71)",*/
		"rgb(91, 15, 0)", "rgb(102, 0, 0)", "rgb(120, 63, 4)", "rgb(127, 96, 0)", "rgb(39, 78, 19)",
		"rgb(12, 52, 61)", "rgb(28, 69, 135)", "rgb(7, 55, 99)", "rgb(32, 18, 77)", "rgb(76, 17, 48)"]
	];

$(function() {
	$("#default_hf_bg").spectrum({
		allowEmpty:true,
		color : "'.(!empty($globals['default_hf_bg']) ? $globals['default_hf_bg'] : '#333333').'",
		showInput: true,
		className: "full-spectrum",
		showInitial: true,
		showPalette: true,
		showSelectionPalette: true,
		maxPaletteSize: 10,
		preferredFormat: "hex",
		localStorageKey: "soft.demo",
		move: function (color) {
			updateColor(color, this.id);
		},
		hide: function (color) {
			updateColor(color, this.id);
		},
		palette: pallete_array
	});
});

$(function() {
	$("#default_cat_hover").spectrum({
		allowEmpty:true,
		color : "'.(!empty($globals['default_cat_hover']) ? $globals['default_cat_hover'] : '#4096ee').'",
		showInput: true,
		className: "full-spectrum",
		showInitial: true,
		showPalette: true,
		showSelectionPalette: true,
		maxPaletteSize: 10,
		preferredFormat: "hex",
		localStorageKey: "soft.demo",
		move: function (color) {
			updateColor(color, this.id);
		},
		hide: function (color) {
			updateColor(color, this.id);
		},
		palette: pallete_array
	});
});

$(function() {
	$("#default_hf_text").spectrum({
		allowEmpty:true,
		color : "'.(!empty($globals['default_hf_text']) ? $globals['default_hf_text'] : '#F2F2F2').'",
		showInput: true,
		className: "full-spectrum",
		showInitial: true,
		showPalette: true,
		showSelectionPalette: true,
		maxPaletteSize: 10,
		preferredFormat: "hex",
		localStorageKey: "soft.demo",
		move: function (color) {
			updateColor(color, this.id);
		},
		hide: function (color) {
			updateColor(color, this.id);
		},
		palette: pallete_array
	});
});

$(function() {
	$("#default_scriptname_text").spectrum({
		allowEmpty:true,
		color : "'.(!empty($globals['default_scriptname_text']) ? $globals['default_scriptname_text'] : '#FFFFFF').'",
		showInput: true,
		className: "full-spectrum",
		showInitial: true,
		showPalette: true,
		showSelectionPalette: true,
		maxPaletteSize: 10,
		preferredFormat: "hex",
		localStorageKey: "soft.demo",
		move: function (color) {
			updateColor(color, this.id);
		},
		hide: function (color) {
			updateColor(color, this.id);
		},
		palette: pallete_array
	});
});
</script>';

softfooter();

}

?>